/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.chocolate.common.biome;

import com.alcatrazescapee.chocolate.common.ChocolateConfig;
import com.alcatrazescapee.chocolate.common.biome.BiomeBridge;
import com.alcatrazescapee.chocolate.common.biome.BiomeContainerBridge;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.provider.BiomeProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BiomeContainerSerializer {
    public static final String PALETTE_KEY = "ChocolateBiomePalette";
    public static final String KEYS_KEY = "Keys";
    public static final String IDS_KEY = "Ids";
    public static final String BIOMES_KEY = "Biomes";
    private static final Logger LOGGER = LogManager.getLogger();

    public static BiomeContainer read(Registry<Biome> biomeRegistry, ChunkPos pos, BiomeProvider biomeProvider, @Nullable int[] biomeData, CompoundNBT nbt) {
        if (biomeData != null && nbt.func_150297_b(PALETTE_KEY, 10)) {
            CompoundNBT paletteNbt = nbt.func_74775_l(PALETTE_KEY);
            ListNBT keysNbt = paletteNbt.func_150295_c(KEYS_KEY, 8);
            int[] savedIds = paletteNbt.func_74759_k(IDS_KEY);
            int[] actualIds = new int[savedIds.length];
            ArrayList<ResourceLocation> missingBiomeNames = new ArrayList<ResourceLocation>();
            for (int i = 0; i < keysNbt.size(); ++i) {
                ResourceLocation key = new ResourceLocation(keysNbt.func_150307_f(i));
                Biome biome = (Biome)biomeRegistry.func_82594_a(key);
                if (biome != null) {
                    actualIds[i] = biomeRegistry.func_148757_b((Object)biome);
                    continue;
                }
                actualIds[i] = -1;
                missingBiomeNames.add(key);
            }
            ChocolateConfig.Severity actionOnMissingBiomes = (ChocolateConfig.Severity)((Object)ChocolateConfig.SERVER.onBiomesRemovedFromChunks.get());
            if (!missingBiomeNames.isEmpty() && actionOnMissingBiomes != ChocolateConfig.Severity.NONE) {
                LOGGER.error("There are biomes in the chunk which are missing from the world! These will be defaulted: " + missingBiomeNames.stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
                if (actionOnMissingBiomes == ChocolateConfig.Severity.THROW) {
                    throw new IllegalStateException("Chocolate threw this error according to the config setting onBiomesRemovedFromChunks = THROW. If reporting this, include the full log as it contains the actual text of the error!");
                }
            }
            HashSet<Integer> missingIds = new HashSet<Integer>();
            for (int i = 0; i < biomeData.length; ++i) {
                int biomeId = biomeData[i];
                boolean foundId = false;
                for (int j = 0; j < savedIds.length; ++j) {
                    if (biomeId != savedIds[j]) continue;
                    biomeData[i] = actualIds[j];
                    foundId = true;
                    break;
                }
                if (foundId) continue;
                missingIds.add(biomeId);
            }
            ChocolateConfig.Severity actionOnMissingIds = (ChocolateConfig.Severity)((Object)ChocolateConfig.SERVER.onIdsMissingFromPalette.get());
            if (!missingIds.isEmpty() && actionOnMissingIds != ChocolateConfig.Severity.NONE) {
                LOGGER.error("There are int IDs present in the biome container with no entry in the palette!");
                LOGGER.error("The biome palette was: " + paletteNbt);
                LOGGER.error("The biome array was: [" + Arrays.stream(biomeData).mapToObj(String::valueOf).collect(Collectors.joining()) + ']');
                LOGGER.error("The missing int IDs were: " + missingIds);
                if (actionOnMissingIds == ChocolateConfig.Severity.THROW) {
                    throw new IllegalStateException("Chocolate threw this error according to the config setting onIdsMissingFromPalette = THROW. If reporting this, include the full log as it contains the actual text of the error!");
                }
            }
        }
        return new BiomeContainer(biomeRegistry, pos, biomeProvider, biomeData);
    }

    public static void write(@Nullable BiomeContainer biomeContainer, CompoundNBT nbt) {
        if (biomeContainer != null && nbt.func_74764_b(BIOMES_KEY)) {
            CompoundNBT paletteNbt = new CompoundNBT();
            Registry<Biome> biomeRegistry = ((BiomeContainerBridge)biomeContainer).bridge$getActualBiomeRegistry();
            Biome[] uniqueBiomes = (Biome[])Arrays.stream(((BiomeContainerBridge)biomeContainer).bridge$getInternalBiomeArray()).distinct().toArray(Biome[]::new);
            int[] ids = new int[uniqueBiomes.length];
            ListNBT keysNbt = new ListNBT();
            for (int i = 0; i < uniqueBiomes.length; ++i) {
                Biome biome = uniqueBiomes[i];
                RegistryKey<Biome> key = BiomeBridge.of(biome).bridge$getKey();
                keysNbt.add((Object)StringNBT.func_229705_a_((String)key.func_240901_a_().toString()));
                ids[i] = biomeRegistry.func_148757_b(biomeRegistry.func_230516_a_(key));
            }
            paletteNbt.func_74783_a(IDS_KEY, ids);
            paletteNbt.func_218657_a(KEYS_KEY, (INBT)keysNbt);
            nbt.func_218657_a(PALETTE_KEY, (INBT)paletteNbt);
        }
    }
}

