/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import mod.chiselsandbits.api.util.IWorldObject;
import net.minecraft.util.math.vector.Vector3d;

public class WorldObjectUtils {
    private WorldObjectUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: WorldObjectUtils. This is a utility class");
    }

    public static boolean isInsideOrCoveredBy(IWorldObject a, IWorldObject b) {
        return WorldObjectUtils.isAInsideOrCoveredByB(a, b) || WorldObjectUtils.isAInsideOrCoveredByB(b, a);
    }

    public static boolean isAInsideOrCoveredByB(IWorldObject a, IWorldObject b) {
        return WorldObjectUtils.isAInsideB(a, b) || WorldObjectUtils.isACoveringB(a, b);
    }

    public static boolean isAInsideB(IWorldObject a, IWorldObject b) {
        Vector3d aStart = a.getInWorldStartPoint();
        Vector3d aEnd = a.getInWorldEndPoint();
        Vector3d bStart = b.getInWorldStartPoint();
        Vector3d bEnd = b.getInWorldEndPoint();
        return bStart.func_82615_a() <= aStart.func_82615_a() && aEnd.func_82615_a() <= bEnd.func_82615_a() && bStart.func_82617_b() <= aStart.func_82617_b() && aEnd.func_82617_b() <= bEnd.func_82617_b() && bStart.func_82616_c() <= aStart.func_82616_c() && aEnd.func_82616_c() <= bEnd.func_82616_c();
    }

    public static boolean isACoveringB(IWorldObject a, IWorldObject b) {
        Vector3d bLowerLeftFront = b.getInWorldStartPoint();
        Vector3d bUpperRightBack = b.getInWorldEndPoint();
        Vector3d bLowerLeftBack = new Vector3d(bLowerLeftFront.func_82615_a(), bLowerLeftFront.func_82617_b(), bUpperRightBack.func_82616_c());
        Vector3d bUpperLeftFront = new Vector3d(bLowerLeftFront.func_82615_a(), bUpperRightBack.func_82617_b(), bLowerLeftFront.func_82616_c());
        Vector3d bLowerRightFront = new Vector3d(bUpperRightBack.func_82615_a(), bLowerLeftFront.func_82617_b(), bLowerLeftFront.func_82616_c());
        Vector3d bUpperLeftBack = new Vector3d(bLowerLeftFront.func_82615_a(), bUpperRightBack.func_82617_b(), bUpperRightBack.func_82616_c());
        Vector3d bLowerRightBack = new Vector3d(bUpperRightBack.func_82615_a(), bLowerLeftFront.func_82617_b(), bUpperRightBack.func_82616_c());
        Vector3d bUpperRightFront = new Vector3d(bUpperRightBack.func_82615_a(), bUpperRightBack.func_82617_b(), bLowerLeftFront.func_82616_c());
        return WorldObjectUtils.isPointInside(a, bLowerLeftFront) || WorldObjectUtils.isPointInside(a, bUpperRightBack) || WorldObjectUtils.isPointInside(a, bLowerLeftBack) || WorldObjectUtils.isPointInside(a, bLowerRightFront) || WorldObjectUtils.isPointInside(a, bUpperLeftFront) || WorldObjectUtils.isPointInside(a, bLowerRightBack) || WorldObjectUtils.isPointInside(a, bUpperLeftBack) || WorldObjectUtils.isPointInside(a, bUpperRightFront);
    }

    public static boolean isPointInside(IWorldObject a, Vector3d point) {
        Vector3d aStart = a.getInWorldStartPoint();
        Vector3d aEnd = a.getInWorldEndPoint();
        return aStart.func_82615_a() <= point.func_82615_a() && point.func_82615_a() <= aEnd.func_82615_a() && aStart.func_82617_b() <= point.func_82617_b() && point.func_82617_b() <= aEnd.func_82617_b() && aStart.func_82616_c() <= point.func_82616_c() && point.func_82616_c() <= aEnd.func_82616_c();
    }
}

