/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.palette.ArrayPalette;
import net.minecraft.util.palette.HashMapPalette;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.IdentityPalette;
import net.minecraftforge.registries.GameData;

public class PaletteUtils {
    private PaletteUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: PaletteUtils. This is a utility class");
    }

    public static List<BlockState> getOrderedListInPalette(IPalette<BlockState> stateIPalette) {
        if (stateIPalette instanceof ArrayPalette) {
            return Arrays.asList((BlockState[])((ArrayPalette)stateIPalette).field_186042_a);
        }
        if (stateIPalette instanceof HashMapPalette) {
            IntIdentityHashBiMap map = ((HashMapPalette)stateIPalette).field_186046_a;
            ArrayList dataList = Lists.newArrayList((Iterable)map);
            dataList.sort(Comparator.comparing(arg_0 -> ((IntIdentityHashBiMap)map).func_148757_b(arg_0)));
            return dataList;
        }
        if (stateIPalette instanceof IdentityPalette) {
            ArrayList dataList = Lists.newArrayList((Iterable)GameData.getBlockStateIDMap());
            dataList.sort(Comparator.comparing(arg_0 -> ((ObjectIntIdentityMap)GameData.getBlockStateIDMap()).func_148757_b(arg_0)));
            return dataList;
        }
        throw new IllegalArgumentException("The given palette type is unknown.");
    }

    public static void read(IPalette<BlockState> stateIPalette, PacketBuffer buffer) {
        ArrayPalette palette;
        if (stateIPalette instanceof ArrayPalette) {
            palette = (ArrayPalette)stateIPalette;
            palette.field_186045_d = buffer.func_150792_a();
            Object[] statesArray = palette.field_186042_a;
            for (int i = 0; i < palette.field_186045_d; ++i) {
                Object registryEntry;
                statesArray[i] = registryEntry = palette.field_205507_a.func_148745_a(buffer.func_150792_a());
            }
        }
        if (stateIPalette instanceof HashMapPalette) {
            palette = (HashMapPalette)stateIPalette;
            palette.field_186046_a.func_186812_a();
            int i = buffer.func_150792_a();
            for (int j = 0; j < i; ++j) {
                palette.field_186046_a.func_186808_c((Object)Objects.requireNonNull((BlockState)palette.field_205509_a.func_148745_a(buffer.func_150792_a())));
            }
        }
    }
}

