/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.multistate.snapshot.LazilyDecodingSingleBlockMultiStateSnapshot;
import mod.chiselsandbits.utils.ChunkSectionUtils;
import net.minecraft.block.BlockState;
import net.minecraft.world.chunk.ChunkSection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiStateSnapshotUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Cache<BlockState, ChunkSection> FILLED_SECTION_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    private MultiStateSnapshotUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: MultiStateSnapshotUtils. This is a utility class");
    }

    public static IMultiStateSnapshot createFromSection(ChunkSection chunkSection) {
        return new LazilyDecodingSingleBlockMultiStateSnapshot(ChunkSectionUtils.serializeNBT(chunkSection));
    }

    public static IMultiStateSnapshot createFilledWith(BlockState blockState) {
        try {
            ChunkSection chunkSection = (ChunkSection)FILLED_SECTION_CACHE.get((Object)blockState, () -> {
                ChunkSection result = new ChunkSection(0);
                BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).forEach(pos -> result.func_222629_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), blockState));
                return result;
            });
            return MultiStateSnapshotUtils.createFromSection(chunkSection);
        }
        catch (ExecutionException e) {
            LOGGER.warn("Failed to get a filled snapshot for: " + blockState + ". The filling of the chunksection was aborted.", (Throwable)e);
            return EmptySnapshot.INSTANCE;
        }
    }
}

