/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.Random;
import mod.chiselsandbits.api.item.INoHitEffectsItem;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EffectUtils {
    private static final Random RANDOM = new Random();

    private EffectUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: EffectUtils. This is a utility class");
    }

    public static boolean addBlockDestroyEffects(IWorldReader world, BlockPos pos, BlockState primaryState, ParticleManager manager, World renderingWorld) {
        if (!primaryState.func_177230_c().isAir(primaryState, (IBlockReader)world, pos)) {
            VoxelShape voxelshape = primaryState.func_196954_c((IBlockReader)world, pos);
            voxelshape.func_197755_b((p_228348_3_, p_228348_5_, p_228348_7_, p_228348_9_, p_228348_11_, p_228348_13_) -> {
                double d1 = Math.min(1.0, p_228348_9_ - p_228348_3_);
                double d2 = Math.min(1.0, p_228348_11_ - p_228348_5_);
                double d3 = Math.min(1.0, p_228348_13_ - p_228348_7_);
                int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
                int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
                int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
                for (int l = 0; l < i; ++l) {
                    for (int i1 = 0; i1 < j; ++i1) {
                        for (int j1 = 0; j1 < k; ++j1) {
                            double d4 = ((double)l + 0.5) / (double)i;
                            double d5 = ((double)i1 + 0.5) / (double)j;
                            double d6 = ((double)j1 + 0.5) / (double)k;
                            double d7 = d4 * d1 + p_228348_3_;
                            double d8 = d5 * d2 + p_228348_5_;
                            double d9 = d6 * d3 + p_228348_7_;
                            manager.func_78873_a((Particle)new DiggingParticle((ClientWorld)renderingWorld, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, primaryState).func_174846_a(pos));
                        }
                    }
                }
            });
        }
        return true;
    }

    public static boolean addHitEffects(World world, BlockRayTraceResult blockRayTraceResult, BlockState primaryState, ParticleManager manager) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return false;
        }
        ItemStack hitWith = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (!hitWith.func_190926_b() && hitWith.func_77973_b() instanceof INoHitEffectsItem) {
            return true;
        }
        BlockPos pos = blockRayTraceResult.func_216350_a();
        float boxOffset = 0.1f;
        AxisAlignedBB bb = world.func_180495_p(pos).func_177230_c().func_220053_a(primaryState, (IBlockReader)world, pos, ISelectionContext.func_216377_a()).func_197752_a();
        double x = RANDOM.nextDouble() * (bb.field_72336_d - bb.field_72340_a - (double)0.2f) + (double)0.1f + bb.field_72340_a;
        double y = RANDOM.nextDouble() * (bb.field_72337_e - bb.field_72338_b - (double)0.2f) + (double)0.1f + bb.field_72338_b;
        double z = RANDOM.nextDouble() * (bb.field_72334_f - bb.field_72339_c - (double)0.2f) + (double)0.1f + bb.field_72339_c;
        switch (blockRayTraceResult.func_216354_b()) {
            case DOWN: {
                y = bb.field_72338_b - (double)0.1f;
                break;
            }
            case EAST: {
                x = bb.field_72336_d + (double)0.1f;
                break;
            }
            case NORTH: {
                z = bb.field_72339_c - (double)0.1f;
                break;
            }
            case SOUTH: {
                z = bb.field_72334_f + (double)0.1f;
                break;
            }
            case UP: {
                y = bb.field_72337_e + (double)0.1f;
                break;
            }
            case WEST: {
                x = bb.field_72340_a - (double)0.1f;
                break;
            }
        }
        manager.func_78873_a(new DiggingParticle((ClientWorld)world, x, y, z, 0.0, 0.0, 0.0, primaryState).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }
}

