/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.modification.operation;

import java.util.Optional;
import mod.chiselsandbits.api.modification.operation.IModificationOperation;
import mod.chiselsandbits.api.modification.operation.IModificationOperationGroup;
import mod.chiselsandbits.api.multistate.mutator.IGenerallyModifiableAreaMutator;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.registrars.ModModificationOperationGroups;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class RotateAroundAxisModificationOperation
extends ForgeRegistryEntry<IModificationOperation>
implements IModificationOperation {
    private final Direction.Axis axis;

    private RotateAroundAxisModificationOperation(Direction.Axis axis) {
        this.axis = axis;
    }

    @Override
    public void apply(IGenerallyModifiableAreaMutator source) {
        source.rotate(this.axis);
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return ModModificationOperationGroups.ROTATE.getIcon();
    }

    @Override
    @NotNull
    public Optional<IModificationOperationGroup> getGroup() {
        return Optional.of(ModModificationOperationGroups.ROTATE);
    }

    @Override
    public ITextComponent getDisplayName() {
        switch (this.axis) {
            case X: {
                return LocalStrings.PatternModificationAcrossXAxis.getText();
            }
            case Y: {
                return LocalStrings.PatternModificationAcrossYAxis.getText();
            }
            case Z: {
                return LocalStrings.PatternModificationAcrossZAxis.getText();
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.axis);
    }

    public static final class Builder {
        private Direction.Axis axis;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder withAxis(Direction.Axis axis) {
            this.axis = axis;
            return this;
        }

        public RotateAroundAxisModificationOperation build() {
            return new RotateAroundAxisModificationOperation(this.axis);
        }
    }
}

