/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.legacy.serialization.blob;

import java.util.List;
import java.util.Objects;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.legacy.serialization.blob.BlobSerializer;
import mod.chiselsandbits.utils.PaletteUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.palette.HashMapPalette;
import net.minecraft.util.palette.IResizeCallback;
import net.minecraftforge.registries.GameData;
import org.jetbrains.annotations.NotNull;

public class NbtBasedPalettedBlobSerializer
extends BlobSerializer
implements IResizeCallback<BlockState> {
    private final ObjectIntIdentityMap<BlockState> registry = GameData.getBlockStateIDMap();
    private final HashMapPalette<BlockState> palette = new HashMapPalette(this.registry, 16, (IResizeCallback)this, NBTUtil::func_190008_d, NBTUtil::func_190009_a);

    public NbtBasedPalettedBlobSerializer(PacketBuffer toInflate) {
        CompoundNBT wrapper = toInflate.func_150793_b();
        ListNBT paletteNBT = Objects.requireNonNull(wrapper).func_150295_c("data", 10);
        this.palette.func_196968_a(paletteNBT);
    }

    @Override
    public void write(PacketBuffer to) {
        ListNBT paletteNBT = new ListNBT();
        this.palette.func_196969_b(paletteNBT);
        CompoundNBT wrapper = new CompoundNBT();
        wrapper.func_218657_a("data", (INBT)paletteNBT);
        to.func_150786_a(wrapper);
    }

    @Override
    protected int readStateID(PacketBuffer buffer) {
        return 0;
    }

    @Override
    protected void writeStateID(PacketBuffer buffer, int key) {
    }

    @Override
    protected int getIndex(int stateID) {
        return this.palette.func_186041_a((Object)IBlockStateIdManager.getInstance().getBlockStateFrom(stateID));
    }

    @Override
    protected int getStateID(int indexID) {
        return IBlockStateIdManager.getInstance().getIdFrom((BlockState)this.palette.func_186039_a(indexID));
    }

    @Override
    public int getVersion() {
        return 4;
    }

    public int onResize(int newBitSize, @NotNull BlockState violatingBlockState) {
        List<BlockState> ids = PaletteUtils.getOrderedListInPalette(this.palette);
        ids.forEach(arg_0 -> this.palette.func_186041_a(arg_0));
        return this.palette.func_186041_a((Object)violatingBlockState);
    }
}

