/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.inventory.bit;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import mod.chiselsandbits.api.inventory.bit.watchable.IWatch;
import mod.chiselsandbits.api.inventory.bit.watchable.IWatchableBitInventory;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import mod.chiselsandbits.inventory.bit.AbstractBitInventory;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.GameData;
import org.jetbrains.annotations.NotNull;

public class SlottedBitInventory
extends AbstractBitInventory
implements IWatchableBitInventory,
INBTSerializable<CompoundNBT> {
    protected final int size;
    protected final Int2ObjectMap<BitSlot> slotMap = new Int2ObjectArrayMap();
    private final Map<UUID, Runnable> onChangeCallbacks = Maps.newConcurrentMap();

    public SlottedBitInventory(int size) {
        this.size = size;
    }

    @Override
    protected ItemStack getItem(int index) {
        BitSlot bitSlot = (BitSlot)this.slotMap.get(index);
        if (bitSlot == null) {
            return ItemStack.field_190927_a;
        }
        return bitSlot.internalStack;
    }

    @Override
    protected int getInventorySize() {
        return this.size;
    }

    @Override
    protected void setSlotContents(int index, ItemStack stack) {
        if (stack.func_190926_b()) {
            this.slotMap.remove(index);
            this.onChange();
            return;
        }
        if (!(stack.func_77973_b() instanceof IBitItem)) {
            throw new IllegalArgumentException("Can not insert a none bit item into the inventory.");
        }
        IBitItem bitItem = (IBitItem)stack.func_77973_b();
        BlockState state = bitItem.getBitState(stack);
        BitSlot slot = (BitSlot)this.slotMap.get(index);
        if (slot == null) {
            slot = new BitSlot();
        }
        slot.setState(state);
        slot.setCount(stack.func_190916_E());
        if (!this.slotMap.containsKey(index)) {
            this.slotMap.put(index, (Object)slot);
        }
        this.onChange();
    }

    @Override
    public IWatch startWatching(Runnable onChangeCallback) {
        UUID id = UUID.randomUUID();
        this.onChangeCallbacks.put(id, onChangeCallback);
        return () -> this.onChangeCallbacks.remove(id);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT data = new CompoundNBT();
        this.slotMap.forEach((index, slot) -> data.func_218657_a(index.toString(), (INBT)slot.serializeNBT()));
        return data;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.slotMap.clear();
        nbt.func_150296_c().forEach(indexRep -> {
            int index = Integer.parseInt(indexRep);
            BitSlot slot = new BitSlot();
            slot.deserializeNBT(nbt.func_74775_l(indexRep));
            this.slotMap.put(index, (Object)slot);
        });
        this.onChange();
    }

    protected Collection<BitSlot> getContents() {
        return this.slotMap.values();
    }

    protected void onChange() {
        this.onChangeCallbacks.values().forEach(Runnable::run);
    }

    @Override
    public boolean isEmpty() {
        return this.slotMap.isEmpty() || this.slotMap.values().stream().allMatch(slot -> slot.getCount() == 0);
    }

    protected static final class BitSlot
    implements INBTSerializable<CompoundNBT>,
    IPacketBufferSerializable {
        private BlockState state = Blocks.field_150350_a.func_176223_P();
        private ItemStack internalStack = ItemStack.field_190927_a;

        public BitSlot() {
        }

        public BitSlot(BlockState state, int count) {
            this.state = state;
            this.internalStack = IBitItemManager.getInstance().create(state, count);
        }

        @Override
        public void serializeInto(@NotNull PacketBuffer packetBuffer) {
            packetBuffer.func_150787_b(GameData.getBlockStateIDMap().func_148757_b((Object)this.state));
            packetBuffer.func_150787_b(this.getCount());
        }

        @Override
        public void deserializeFrom(@NotNull PacketBuffer packetBuffer) {
            this.state = (BlockState)GameData.getBlockStateIDMap().func_148745_a(packetBuffer.func_150792_a());
            int count = packetBuffer.func_150792_a();
            this.internalStack = IBitItemManager.getInstance().create(this.state, count);
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT data = new CompoundNBT();
            data.func_218657_a("blockState", (INBT)NBTUtil.func_190009_a((BlockState)this.state));
            data.func_74768_a("count", this.getCount());
            return data;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.state = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("blockState"));
            int count = nbt.func_74762_e("count");
            this.internalStack = IBitItemManager.getInstance().create(this.state, count);
        }

        public BlockState getState() {
            return this.state;
        }

        public int getCount() {
            return this.internalStack.func_190916_E();
        }

        public void setState(BlockState state) {
            if (this.state == state) {
                return;
            }
            this.state = state;
            this.internalStack = IBitItemManager.getInstance().create(state, 1);
        }

        public void setCount(int count) {
            this.internalStack.func_190920_e(count);
        }
    }
}

