/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.container;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItem;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.container.helper.MergeSupportingHelperContainer;
import mod.chiselsandbits.inventory.wrapping.WrappingInventory;
import mod.chiselsandbits.network.packets.BagGuiStackPacket;
import mod.chiselsandbits.registrars.ModContainerTypes;
import mod.chiselsandbits.slots.BitSlot;
import mod.chiselsandbits.slots.ReadonlySlot;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BagContainer
extends Container {
    static final int OUTER_SLOT_SIZE = 18;
    public final List<Slot> customSlots = new ArrayList<Slot>();
    public final List<ItemStack> customSlotsItems = new ArrayList<ItemStack>();
    final PlayerEntity thePlayer;
    final WrappingInventory visibleInventory = new WrappingInventory();
    IBitInventoryItemStack bagInv;
    ReadonlySlot bagSlot;

    public BagContainer(int id, PlayerInventory playerInventory) {
        super((ContainerType)ModContainerTypes.BIT_BAG.get(), id);
        this.thePlayer = playerInventory.field_70458_d;
        int playerInventoryOffset = 54;
        ItemStack is = this.thePlayer.func_184614_ca();
        this.setBag(is);
        for (int yOffset = 0; yOffset < 7; ++yOffset) {
            for (int xOffset = 0; xOffset < 9; ++xOffset) {
                this.addCustomSlot(new BitSlot(this.visibleInventory, xOffset + yOffset * 9, 8 + xOffset * 18, 18 + yOffset * 18));
            }
        }
        for (int xPlayerInventory = 0; xPlayerInventory < 3; ++xPlayerInventory) {
            for (int yPlayerInventory = 0; yPlayerInventory < 9; ++yPlayerInventory) {
                this.func_75146_a(new Slot((IInventory)this.thePlayer.field_71071_by, yPlayerInventory + xPlayerInventory * 9 + 9, 8 + yPlayerInventory * 18, 104 + xPlayerInventory * 18 + 54));
            }
        }
        for (int xToolbar = 0; xToolbar < 9; ++xToolbar) {
            if (this.thePlayer.field_71071_by.field_70461_c == xToolbar) {
                this.bagSlot = new ReadonlySlot((IInventory)this.thePlayer.field_71071_by, xToolbar, 8 + xToolbar * 18, 216);
                this.func_75146_a(this.bagSlot);
                continue;
            }
            this.func_75146_a(new Slot((IInventory)this.thePlayer.field_71071_by, xToolbar, 8 + xToolbar * 18, 216));
        }
    }

    private void setBag(ItemStack bagItem) {
        if (!bagItem.func_190926_b() && bagItem.func_77973_b() instanceof IBitInventoryItem) {
            IBitInventoryItem bitInventoryItem = (IBitInventoryItem)bagItem.func_77973_b();
            this.bagInv = bitInventoryItem.create(bagItem);
            this.visibleInventory.setWrapped(this.bagInv);
        } else {
            this.bagInv = null;
        }
    }

    private void addCustomSlot(BitSlot newSlot) {
        newSlot.field_75222_d = this.customSlots.size();
        this.customSlots.add(newSlot);
        this.customSlotsItems.add(ItemStack.field_190927_a);
    }

    public void handleCustomSlotAction(int slotNumber, int mouseButton, boolean duplicateButton, boolean holdingShift) {
        Slot slot = this.customSlots.get(slotNumber);
        ItemStack held = this.thePlayer.field_71071_by.func_70445_o();
        ItemStack slotStack = slot.func_75211_c();
        if (duplicateButton && this.thePlayer.func_184812_l_()) {
            if (slot.func_75216_d() && held.func_190926_b()) {
                ItemStack is = slot.func_75211_c().func_77946_l();
                is.func_190920_e(is.func_77976_d());
                this.thePlayer.field_71071_by.func_70437_b(is);
            }
        } else if (holdingShift) {
            if (!slotStack.func_190926_b()) {
                this.transferStack(slotNumber, false);
            }
        } else if (mouseButton == 0 && !duplicateButton) {
            if (held.func_190926_b() && slot.func_75216_d()) {
                ItemStack pulled = slotStack.func_77946_l();
                pulled.func_190920_e(Math.min(pulled.func_77976_d(), pulled.func_190916_E()));
                ItemStack newStackSlot = slotStack.func_77946_l();
                newStackSlot.func_190920_e(pulled.func_190916_E() >= slotStack.func_190916_E() ? 0 : slotStack.func_190916_E() - pulled.func_190916_E());
                slot.func_75215_d(newStackSlot.func_190916_E() <= 0 ? ItemStack.field_190927_a : newStackSlot);
                this.thePlayer.field_71071_by.func_70437_b(pulled);
            } else if (!held.func_190926_b() && slot.func_75216_d() && slot.func_75214_a(held)) {
                if (held.func_77973_b() == slotStack.func_77973_b() && held.func_77952_i() == slotStack.func_77952_i() && ItemStack.func_77970_a((ItemStack)held, (ItemStack)slotStack)) {
                    ItemStack newStackSlot = slotStack.func_77946_l();
                    newStackSlot.func_190920_e(newStackSlot.func_190916_E() + held.func_190916_E());
                    int held_stackSize = 0;
                    if (newStackSlot.func_190916_E() > slot.func_75219_a()) {
                        held_stackSize = newStackSlot.func_190916_E() - slot.func_75219_a();
                        newStackSlot.func_190920_e(newStackSlot.func_190916_E() - held_stackSize);
                    }
                    slot.func_75215_d(newStackSlot);
                    held.func_190920_e(held_stackSize);
                    this.thePlayer.field_71071_by.func_70437_b(held);
                } else if (!held.func_190926_b() && slot.func_75216_d() && slotStack.func_190916_E() <= slotStack.func_77976_d()) {
                    slot.func_75215_d(held);
                    this.thePlayer.field_71071_by.func_70437_b(slotStack);
                }
            } else if (!held.func_190926_b() && !slot.func_75216_d() && slot.func_75214_a(held)) {
                slot.func_75215_d(held);
                this.thePlayer.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            }
        } else if (mouseButton == 1 && !duplicateButton) {
            if (held.func_190926_b() && slot.func_75216_d()) {
                ItemStack pulled = slotStack.func_77946_l();
                pulled.func_190920_e(Math.max(1, (Math.min(pulled.func_77976_d(), pulled.func_190916_E()) + 1) / 2));
                ItemStack newStackSlot = slotStack.func_77946_l();
                newStackSlot.func_190920_e(pulled.func_190916_E() >= slotStack.func_190916_E() ? 0 : slotStack.func_190916_E() - pulled.func_190916_E());
                slot.func_75215_d(newStackSlot.func_190916_E() <= 0 ? ItemStack.field_190927_a : newStackSlot);
                this.thePlayer.field_71071_by.func_70437_b(pulled);
            } else if (!held.func_190926_b() && slot.func_75216_d() && slot.func_75214_a(held)) {
                if (held.func_77973_b() == slotStack.func_77973_b() && held.func_77952_i() == slotStack.func_77952_i() && ItemStack.func_77970_a((ItemStack)held, (ItemStack)slotStack)) {
                    ItemStack newStackSlot = slotStack.func_77946_l();
                    newStackSlot.func_190920_e(newStackSlot.func_190916_E() + 1);
                    int held_quantity = held.func_190916_E() - 1;
                    if (newStackSlot.func_190916_E() > slot.func_75219_a()) {
                        int diff = newStackSlot.func_190916_E() - slot.func_75219_a();
                        held_quantity += diff;
                        newStackSlot.func_190920_e(newStackSlot.func_190916_E() - diff);
                    }
                    slot.func_75215_d(newStackSlot);
                    held.func_190920_e(held_quantity);
                    this.thePlayer.field_71071_by.func_70437_b(!held.func_190926_b() ? held : ItemStack.field_190927_a);
                }
            } else if (!held.func_190926_b() && !slot.func_75216_d() && slot.func_75214_a(held)) {
                ItemStack newStackSlot = held.func_77946_l();
                newStackSlot.func_190920_e(newStackSlot.func_190916_E() + 1);
                held.func_190920_e(held.func_190916_E() - 1);
                slot.func_75215_d(newStackSlot);
                this.thePlayer.field_71071_by.func_70437_b(!held.func_190926_b() ? held : ItemStack.field_190927_a);
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int slotIdx = 0; slotIdx < this.customSlots.size(); ++slotIdx) {
            ItemStack realStack = this.customSlots.get(slotIdx).func_75211_c();
            ItemStack clientStack = this.customSlotsItems.get(slotIdx);
            if (ItemStack.func_77989_b((ItemStack)clientStack, (ItemStack)realStack)) continue;
            clientStack = realStack.func_190926_b() ? ItemStack.field_190927_a : realStack.func_77946_l();
            this.customSlotsItems.set(slotIdx, clientStack);
            for (IContainerListener cl : this.field_75149_d) {
                if (!(cl instanceof ServerPlayerEntity)) continue;
                BagGuiStackPacket packet = new BagGuiStackPacket(slotIdx, clientStack);
                ChiselsAndBits.getInstance().getNetworkChannel().sendToPlayer(packet, (ServerPlayerEntity)cl);
            }
        }
    }

    @NotNull
    public ItemStack func_82846_b(@NotNull PlayerEntity playerIn, int index) {
        return this.transferStack(index, true);
    }

    public boolean func_75145_c(@NotNull PlayerEntity playerIn) {
        return this.bagInv != null && playerIn == this.thePlayer && this.hasBagInHand(this.thePlayer);
    }

    private boolean hasBagInHand(PlayerEntity player) {
        if (this.bagInv.toItemStack() != player.func_184614_ca()) {
            this.setBag(player.func_184614_ca());
        }
        return this.bagInv != null && this.bagInv.toItemStack().func_77973_b() instanceof IBitInventoryItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemStack transferStack(int index, boolean normalToBag) {
        ItemStack someReturnValue = ItemStack.field_190927_a;
        boolean reverse = true;
        MergeSupportingHelperContainer helper = new MergeSupportingHelperContainer();
        if (!normalToBag) {
            helper.field_75151_b.clear();
            helper.field_75151_b.addAll(this.customSlots);
        } else {
            helper.field_75151_b.clear();
            helper.field_75151_b.addAll(this.field_75151_b);
            reverse = false;
        }
        Slot slot = (Slot)helper.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            IBitItem bitItem;
            ItemStack transferStack = slot.func_75211_c();
            someReturnValue = transferStack.func_77946_l();
            int extraItems = 0;
            if (transferStack.func_190916_E() > transferStack.func_77976_d()) {
                extraItems = transferStack.func_190916_E() - transferStack.func_77976_d();
                transferStack.func_190920_e(transferStack.func_77976_d());
            }
            if (normalToBag) {
                helper.field_75151_b.clear();
                helper.field_75151_b.addAll(this.customSlots);
            } else {
                helper.field_75151_b.clear();
                helper.field_75151_b.addAll(this.field_75151_b);
            }
            Item transferItem = transferStack.func_77973_b();
            if (transferItem instanceof IBitItem) {
                bitItem = (IBitItem)transferItem;
                bitItem.onMergeOperationWithBagBeginning();
            }
            try {
                if (!helper.doMergeItemStack(transferStack, 0, helper.field_75151_b.size(), reverse)) {
                    bitItem = ItemStack.field_190927_a;
                    return bitItem;
                }
            }
            finally {
                transferStack.func_190920_e(transferStack.func_190916_E() + extraItems);
                if (transferItem instanceof IBitItem) {
                    IBitItem bitItem2 = (IBitItem)transferItem;
                    bitItem2.onMergeOperationWithBagEnding();
                }
            }
            if (transferStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return someReturnValue;
    }

    public void clear(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IBitItem) {
            IBitItem bitItem = (IBitItem)stack.func_77973_b();
            this.bagInv.clear(bitItem.getBitState(stack));
        } else {
            this.bagInv.func_174888_l();
        }
        ((ServerPlayerEntity)this.thePlayer).func_71120_a((Container)this);
    }

    public void sort() {
        this.bagInv.sort();
        ((ServerPlayerEntity)this.thePlayer).func_71120_a((Container)this);
    }
}

