/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.eligibility;

import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.utils.ClassUtils;
import mod.chiselsandbits.utils.ReflectionHelperBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.extensions.IForgeBlock;

public class BlockEligibilityAnalysisData {
    private final boolean isCompatible;
    private final float hardness;
    private final float explosionResistance;

    private BlockEligibilityAnalysisData(boolean isCompatible, float hardness, float explosionResistance) {
        this.isCompatible = isCompatible;
        this.hardness = hardness;
        this.explosionResistance = explosionResistance;
    }

    public boolean isCompatible() {
        return this.isCompatible;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    public static BlockEligibilityAnalysisData createFromState(BlockState state) {
        try {
            boolean isFluid;
            ReflectionHelperBlock reflectBlock = new ReflectionHelperBlock();
            Block blk = state.func_177230_c();
            Class<?> blkClass = blk.getClass();
            reflectBlock.func_180647_a(null, null, null, null);
            Class<?> b_Class = ClassUtils.getDeclaringClass(blkClass, reflectBlock.MethodName, BlockState.class, PlayerEntity.class, IBlockReader.class, BlockPos.class);
            boolean test_b = b_Class == Block.class || b_Class == AbstractBlock.class;
            reflectBlock.func_149638_a();
            Class<?> exploResistanceClz = ClassUtils.getDeclaringClass(blkClass, reflectBlock.MethodName, new Class[0]);
            boolean test_c = exploResistanceClz == Block.class || exploResistanceClz == AbstractBlock.class;
            reflectBlock.getExplosionResistance(null, null, null, null);
            exploResistanceClz = ClassUtils.getDeclaringClass(blkClass, reflectBlock.MethodName, BlockState.class, IBlockReader.class, BlockPos.class, Explosion.class);
            boolean test_d = exploResistanceClz == Block.class || exploResistanceClz == AbstractBlock.class || exploResistanceClz == null || exploResistanceClz == IForgeBlock.class;
            boolean bl = isFluid = !state.func_204520_s().func_206888_e();
            if (test_b && test_c && test_d && !isFluid) {
                float blockHardness = state.func_185887_b((IBlockReader)new SingleBlockBlockReader(state, state.func_177230_c()), BlockPos.field_177992_a);
                float resistance = blk.getExplosionResistance(state, (IBlockReader)new SingleBlockBlockReader(state, state.func_177230_c()), BlockPos.field_177992_a, new Explosion(null, null, null, null, 0.0, 1.0, 0.0, 10.0f, false, Explosion.Mode.NONE));
                return new BlockEligibilityAnalysisData(true, blockHardness, resistance);
            }
            if (test_b && test_c && test_d && isFluid) {
                return new BlockEligibilityAnalysisData(true, 2.0f, 6.0f);
            }
            return new BlockEligibilityAnalysisData((Boolean)Configuration.getInstance().getServer().compatabilityMode.get(), 2.0f, 6.0f);
        }
        catch (Exception err) {
            return new BlockEligibilityAnalysisData(false, -1.0f, -1.0f);
        }
    }
}

