/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.change;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.change.ChangeTracker;
import net.minecraft.entity.player.PlayerEntity;
import org.jetbrains.annotations.NotNull;

public class ChangeTrackerManger
implements IChangeTrackerManager {
    private static final ChangeTrackerManger INSTANCE = new ChangeTrackerManger();
    private final Map<UUID, ChangeTracker> changeTrackers = Maps.newConcurrentMap();
    private final ChangeTracker clientChangeTracker = new ChangeTracker();

    public static ChangeTrackerManger getInstance() {
        return INSTANCE;
    }

    private ChangeTrackerManger() {
    }

    @Override
    @NotNull
    public IChangeTracker getChangeTracker(PlayerEntity player) {
        if (player.field_70170_p.func_201670_d()) {
            return this.clientChangeTracker;
        }
        return this.changeTrackers.computeIfAbsent(player.func_110124_au(), id -> new ChangeTracker(player));
    }

    public void clearCache() {
        this.changeTrackers.values().forEach(ChangeTracker::reset);
        this.changeTrackers.clear();
    }
}

