/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.measuring;

import java.util.function.BiFunction;
import java.util.function.Function;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.util.LocalStrings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;

public enum MeasuringType implements IToolModeGroup
{
    BIT((ITextComponent)LocalStrings.TapeMeasureBit.getText(), new ResourceLocation("chiselsandbits", "textures/icons/bit.png"), v -> Vector3d.func_237491_b_((Vector3i)new BlockPos(v.func_216372_d(16.0, 16.0, 16.0))).func_216372_d(0.0625, 0.0625, 0.0625), (from, to) -> new Vector3d(Math.min(from.func_82615_a(), to.func_82615_a()), Math.min(from.func_82617_b(), to.func_82617_b()), Math.min(from.func_82616_c(), to.func_82616_c())), (from, to) -> new Vector3d(Math.max(from.func_82615_a(), to.func_82615_a()), Math.max(from.func_82617_b(), to.func_82617_b()), Math.max(from.func_82616_c(), to.func_82616_c()))),
    BLOCK((ITextComponent)LocalStrings.TapeMeasureBlock.getText(), new ResourceLocation("chiselsandbits", "textures/icons/block.png"), v -> Vector3d.func_237491_b_((Vector3i)new BlockPos(v)), (from, to) -> new Vector3d(Math.min(from.func_82615_a(), to.func_82615_a()), Math.min(from.func_82617_b(), to.func_82617_b()), Math.min(from.func_82616_c(), to.func_82616_c())), (from, to) -> new Vector3d(Math.max(from.func_82615_a(), to.func_82615_a()), Math.max(from.func_82617_b(), to.func_82617_b()), Math.max(from.func_82616_c(), to.func_82616_c()))),
    DISTANCE((ITextComponent)LocalStrings.TapeMeasureDistance.getText(), new ResourceLocation("chiselsandbits", "textures/icons/line.png"), Function.identity(), (from, to) -> from, (from, to) -> to);

    private final ITextComponent displayName;
    private final ResourceLocation icon;
    private final Function<Vector3d, Vector3d> positionAdapter;
    private final BiFunction<Vector3d, Vector3d, Vector3d> startPositionAdapter;
    private final BiFunction<Vector3d, Vector3d, Vector3d> endPositionAdapter;

    private MeasuringType(ITextComponent displayName, ResourceLocation icon, Function<Vector3d, Vector3d> positionAdapter, BiFunction<Vector3d, Vector3d, Vector3d> startPositionAdapter, BiFunction<Vector3d, Vector3d, Vector3d> endPositionAdapter) {
        this.displayName = displayName;
        this.icon = icon;
        this.positionAdapter = positionAdapter;
        this.startPositionAdapter = startPositionAdapter;
        this.endPositionAdapter = endPositionAdapter;
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public Vector3d adaptPosition(@NotNull Vector3d position) {
        return this.positionAdapter.apply(position);
    }

    @NotNull
    public Vector3d adaptStartPosition(@NotNull Vector3d startPosition, @NotNull Vector3d endPosition) {
        return this.startPositionAdapter.apply(startPosition, endPosition);
    }

    @NotNull
    public Vector3d adaptEndPosition(@NotNull Vector3d startPosition, @NotNull Vector3d endPosition) {
        return this.endPositionAdapter.apply(startPosition, endPosition);
    }
}

