/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.config;

import com.google.common.collect.Lists;
import java.util.List;
import mod.chiselsandbits.api.config.AbstractConfiguration;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfiguration
extends AbstractConfiguration {
    public ForgeConfigSpec.BooleanValue enableRightClickModeChange;
    public ForgeConfigSpec.BooleanValue invertBitBagFullness;
    public ForgeConfigSpec.BooleanValue enableToolbarIcons;
    public ForgeConfigSpec.BooleanValue perChiselMode;
    public ForgeConfigSpec.BooleanValue chatModeNotification;
    public ForgeConfigSpec.BooleanValue itemNameModeDisplay;
    public ForgeConfigSpec.BooleanValue addBrokenBlocksToCreativeClipboard;
    public ForgeConfigSpec.IntValue maxUndoLevel;
    public ForgeConfigSpec.IntValue maxTapeMeasures;
    public ForgeConfigSpec.BooleanValue displayMeasuringTapeInChat;
    public ForgeConfigSpec.DoubleValue radialMenuVolume;
    public ForgeConfigSpec.ConfigValue<List<? extends Float>> previewChiselingColor;
    public ForgeConfigSpec.ConfigValue<List<? extends Float>> previewPlacementColor;
    public ForgeConfigSpec.ConfigValue<String> previewRenderer;
    public ForgeConfigSpec.ConfigValue<String> toolModeRenderer;
    public ForgeConfigSpec.LongValue bitStorageContentCacheSize;
    public ForgeConfigSpec.DoubleValue maxDrawnRegionSize;
    public ForgeConfigSpec.BooleanValue enableFaceLightmapExtraction;
    public ForgeConfigSpec.BooleanValue useGetLightValue;
    public ForgeConfigSpec.BooleanValue disableCustomVertexFormats;
    public ForgeConfigSpec.BooleanValue enableMouseIndicatorInRadialMenu;
    public ForgeConfigSpec.LongValue modelCacheSize;
    public ForgeConfigSpec.LongValue faceLayerCacheSize;
    public ForgeConfigSpec.IntValue modelBuildingThreadCount;
    public ForgeConfigSpec.BooleanValue injectIntoJEI;

    protected ClientConfiguration(ForgeConfigSpec.Builder builder) {
        ClientConfiguration.createCategory(builder, "settings.bit-bag");
        this.invertBitBagFullness = ClientConfiguration.defineBoolean(builder, "invert-durability-bar-indication", false);
        ClientConfiguration.swapToCategory(builder, "settings.selected-tool-mode-icons");
        this.toolModeRenderer = ClientConfiguration.defineString(builder, "renderer", "chiselsandbits:group");
        ClientConfiguration.swapToCategory(builder, "settings.chiseling-previews");
        this.previewRenderer = ClientConfiguration.defineString(builder, "renderer", "chiselsandbits:default");
        ClientConfiguration.swapToCategory(builder, "settings.chiseling-previews.default.colors");
        this.previewChiselingColor = ClientConfiguration.defineList(builder, "chiseling", Lists.newArrayList((Object[])new Float[]{Float.valueOf(0.85f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.65f)}), value -> true);
        this.previewPlacementColor = ClientConfiguration.defineList(builder, "placement", Lists.newArrayList((Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(0.85f), Float.valueOf(0.0f), Float.valueOf(0.65f)}), value -> true);
        ClientConfiguration.swapToCategory(builder, "performance.caches.sizes");
        this.bitStorageContentCacheSize = ClientConfiguration.defineLong(builder, "bit-storage-content-models", 100L, 0L, Long.MAX_VALUE);
        this.modelCacheSize = ClientConfiguration.defineLong(builder, "block-models", 10000L, 3500L, 20000L);
        this.faceLayerCacheSize = ClientConfiguration.defineLong(builder, "block-faces", 10000L, 3500L, 20000L);
        ClientConfiguration.swapToCategory(builder, "performance.model-building");
        this.modelBuildingThreadCount = ClientConfiguration.defineInteger(builder, "thead-count", Math.max(1, Runtime.getRuntime().availableProcessors()) / 2, 1, Runtime.getRuntime().availableProcessors());
        ClientConfiguration.swapToCategory(builder, "performance.lighting");
        this.enableFaceLightmapExtraction = ClientConfiguration.defineBoolean(builder, "extract-lighting-values-from-faces", true);
        this.useGetLightValue = ClientConfiguration.defineBoolean(builder, "extract-lighting-values-from-blockstates", true);
        ClientConfiguration.swapToCategory(builder, "gui.radial-menu");
        this.enableMouseIndicatorInRadialMenu = ClientConfiguration.defineBoolean(builder, "display-mouse-indicator", false);
        ClientConfiguration.finishCategory(builder);
        ClientConfiguration.createCategory(builder, "compat.jei");
        this.injectIntoJEI = ClientConfiguration.defineBoolean(builder, "inject-bits", true);
        ClientConfiguration.finishCategory(builder);
    }
}

