/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.config;

import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import mod.chiselsandbits.api.util.DeprecationHelper;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class AbstractConfiguration {
    public static final Set<String> LANG_KEYS = Sets.newLinkedHashSet();
    private static String currentCategory = "";
    private static final LinkedList<String> categoryStack = new LinkedList();
    private static final LinkedList<Integer> additionalDepthCount = new LinkedList();

    public AbstractConfiguration() {
        categoryStack.push("");
    }

    protected static void createCategory(ForgeConfigSpec.Builder builder, String key) {
        String translation;
        String[] keySections;
        String originalKey = key;
        if (!currentCategory.isEmpty()) {
            key = currentCategory + "." + key;
        }
        if ((keySections = key.split("\\.")).length > 1) {
            String workingKey = "";
            for (int i = 0; i < keySections.length - 1; ++i) {
                String translation2;
                if (!workingKey.isEmpty()) {
                    workingKey = workingKey + ".";
                }
                builder.comment((translation2 = DeprecationHelper.translateToLocal(AbstractConfiguration.commentTKey(workingKey = workingKey + keySections[i]))) == null || translation2.isEmpty() ? workingKey : translation2).push(keySections[i]);
            }
        }
        builder.comment((translation = DeprecationHelper.translateToLocal(AbstractConfiguration.commentTKey(key))) == null || translation.isEmpty() ? key : translation).push(keySections[keySections.length - 1]);
        currentCategory = key;
        additionalDepthCount.addFirst(originalKey.split("\\.").length);
        categoryStack.push(key);
    }

    protected static void swapToCategory(ForgeConfigSpec.Builder builder, String key) {
        AbstractConfiguration.finishCategory(builder);
        AbstractConfiguration.createCategory(builder, key);
    }

    protected static void finishCategory(ForgeConfigSpec.Builder builder) {
        if (currentCategory.isEmpty()) {
            return;
        }
        int popCount = additionalDepthCount.removeFirst();
        for (int i = 0; i < popCount; ++i) {
            builder.pop();
        }
        categoryStack.removeFirst();
        currentCategory = categoryStack.peekFirst();
    }

    private static String nameTKey(String key) {
        return currentCategory.isEmpty() ? String.format("mod.%s.config.%s", "chiselsandbits", key) : String.format("mod.%s.config.%s.%s", "chiselsandbits", currentCategory, key);
    }

    private static String commentTKey(String key) {
        String tComKey = String.format("%s.comment", AbstractConfiguration.nameTKey(key));
        LANG_KEYS.add(tComKey);
        return tComKey;
    }

    private static ForgeConfigSpec.Builder buildBase(ForgeConfigSpec.Builder builder, String key) {
        String translation = DeprecationHelper.translateToLocal(AbstractConfiguration.commentTKey(key));
        return builder.comment(translation == null || translation.isEmpty() ? key : translation).translation(AbstractConfiguration.nameTKey(key));
    }

    protected static ForgeConfigSpec.BooleanValue defineBoolean(ForgeConfigSpec.Builder builder, String key, boolean defaultValue) {
        return AbstractConfiguration.buildBase(builder, key).define(key, defaultValue);
    }

    protected static ForgeConfigSpec.IntValue defineInteger(ForgeConfigSpec.Builder builder, String key, int defaultValue) {
        return AbstractConfiguration.defineInteger(builder, key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    protected static ForgeConfigSpec.IntValue defineInteger(ForgeConfigSpec.Builder builder, String key, int defaultValue, int min, int max) {
        return AbstractConfiguration.buildBase(builder, key).defineInRange(key, defaultValue, min, max);
    }

    protected static ForgeConfigSpec.LongValue defineLong(ForgeConfigSpec.Builder builder, String key, long defaultValue) {
        return AbstractConfiguration.defineLong(builder, key, defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    protected static ForgeConfigSpec.LongValue defineLong(ForgeConfigSpec.Builder builder, String key, long defaultValue, long min, long max) {
        return AbstractConfiguration.buildBase(builder, key).defineInRange(key, defaultValue, min, max);
    }

    protected static ForgeConfigSpec.DoubleValue defineDouble(ForgeConfigSpec.Builder builder, String key, double defaultValue) {
        return AbstractConfiguration.defineDouble(builder, key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    protected static ForgeConfigSpec.DoubleValue defineDouble(ForgeConfigSpec.Builder builder, String key, double defaultValue, double min, double max) {
        return AbstractConfiguration.buildBase(builder, key).defineInRange(key, defaultValue, min, max);
    }

    protected static <T> ForgeConfigSpec.ConfigValue<List<? extends T>> defineList(ForgeConfigSpec.Builder builder, String key, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
        return AbstractConfiguration.buildBase(builder, key).defineList(key, defaultValue, elementValidator);
    }

    protected static <V extends Enum<V>> ForgeConfigSpec.EnumValue<V> defineEnum(ForgeConfigSpec.Builder builder, String key, V defaultValue) {
        return AbstractConfiguration.buildBase(builder, key).defineEnum(key, defaultValue);
    }

    protected static ForgeConfigSpec.ConfigValue<String> defineString(ForgeConfigSpec.Builder builder, String key, String defaultValue) {
        return AbstractConfiguration.buildBase(builder, key).define(key, (Object)defaultValue);
    }
}

