/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.aabb;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.utils.AABBUtils;
import mod.chiselsandbits.utils.DirectionUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class AABBCompressor {
    private AABBCompressor() {
        throw new IllegalStateException("Can not instantiate an instance of: AABBCompressor. This is a utility class");
    }

    public static Collection<AxisAlignedBB> compressStates(IAreaAccessor accessor, Predicate<IStateEntryInfo> selectablePredicate) {
        BuildingState state = new BuildingState();
        accessor.streamWithPositionMutator(IPositionMutator.xyz()).forEach(stateEntryInfo -> {
            if (state.getRegionBuildingAxisValue() != stateEntryInfo.getStartPoint().func_82615_a()) {
                state.setCurrentBox(null, null);
            }
            state.setRegionBuildingAxisValue(stateEntryInfo.getStartPoint().func_82615_a());
            if (state.getFaceBuildingAxisValue() != stateEntryInfo.getStartPoint().func_82617_b()) {
                state.setCurrentBox(null, null);
            }
            state.setFaceBuildingAxisValue(stateEntryInfo.getStartPoint().func_82617_b());
            Optional<Vector3d> previousCenterPoint = state.getLastCenter();
            Vector3d centerPoint = stateEntryInfo.getCenterPoint();
            state.onNextEntry(centerPoint);
            Optional<Boolean> stepDirection = previousCenterPoint.flatMap(d -> DirectionUtils.getDirectionVectorBetweenIfAligned(centerPoint, d));
            Optional<AxisAlignedBB> potentialEntryData = AABBCompressor.buildBoundingBox(stateEntryInfo, selectablePredicate);
            if (!potentialEntryData.isPresent()) {
                state.setCurrentBox(null, centerPoint);
                return;
            }
            AxisAlignedBB entryData = potentialEntryData.get();
            if (state.getCurrentBox() != null && stepDirection.map(direction -> AABBUtils.areBoxesNeighbors(state.getCurrentBox(), entryData, direction)).filter(b -> b).isPresent()) {
                state.expandCurrentBoxToInclude(entryData, centerPoint);
                if (AABBCompressor.attemptMergeWithNeighbors(state, centerPoint, state.getCurrentBox())) {
                    return;
                }
                return;
            }
            if (AABBCompressor.attemptMergeWithNeighbors(state, centerPoint, entryData)) {
                return;
            }
            state.setCurrentBox(potentialEntryData.get(), centerPoint);
        });
        return Lists.newArrayList(state.getBoxes());
    }

    private static boolean attemptMergeWithNeighbors(BuildingState state, Vector3d centerPoint, AxisAlignedBB entryData) {
        for (Direction offsetDirection : Direction.values()) {
            AxisAlignedBB neighborBox;
            Vector3d neighborCenter = centerPoint.func_178787_e(Vector3d.func_237491_b_((Vector3i)offsetDirection.func_176730_m()).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
            Optional<AxisAlignedBB> potentialNeighborBox = state.getBoxFor(neighborCenter);
            if (!potentialNeighborBox.isPresent() || !AABBUtils.areBoxesNeighbors(entryData, neighborBox = potentialNeighborBox.get(), offsetDirection)) continue;
            state.expandBoxAt(neighborCenter, entryData, centerPoint);
            return true;
        }
        return false;
    }

    public static Optional<AxisAlignedBB> buildBoundingBox(IStateEntryInfo stateEntryInfo, Predicate<IStateEntryInfo> selectablePredicate) {
        if (!selectablePredicate.test(stateEntryInfo)) {
            return Optional.empty();
        }
        return Optional.of(stateEntryInfo.getBoundingBox());
    }

    private static final class BuildingState {
        private double regionBuildingAxis = Double.NEGATIVE_INFINITY;
        private double faceBuildingAxis = Double.NEGATIVE_INFINITY;
        private Vector3d lastCenterPoint = null;
        private AxisAlignedBB currentBox;
        private final Map<Vector3d, AxisAlignedBB> boxAssignments = Maps.newHashMap();
        private final Multimap<AxisAlignedBB, Vector3d> stateAssignments = HashMultimap.create();

        private BuildingState() {
        }

        public double getRegionBuildingAxisValue() {
            return this.regionBuildingAxis;
        }

        public void setRegionBuildingAxisValue(double regionBuildingAxis) {
            this.regionBuildingAxis = regionBuildingAxis;
        }

        public double getFaceBuildingAxisValue() {
            return this.faceBuildingAxis;
        }

        public void setFaceBuildingAxisValue(double faceBuildingAxis) {
            this.faceBuildingAxis = faceBuildingAxis;
        }

        public AxisAlignedBB getCurrentBox() {
            return this.currentBox;
        }

        public void setCurrentBox(AxisAlignedBB currentBox, Vector3d centerPoint) {
            this.currentBox = currentBox;
            if (currentBox != null) {
                this.boxAssignments.put(centerPoint, currentBox);
                this.stateAssignments.put((Object)currentBox, (Object)centerPoint);
            }
        }

        public Optional<AxisAlignedBB> getBoxFor(Vector3d target) {
            return Optional.ofNullable(this.boxAssignments.get(target));
        }

        public Optional<Vector3d> getLastCenter() {
            return Optional.ofNullable(this.lastCenterPoint);
        }

        public void onNextEntry(Vector3d lastCenterPoint) {
            this.lastCenterPoint = lastCenterPoint;
        }

        public void expandCurrentBoxToInclude(AxisAlignedBB entryData, Vector3d centerPoint) {
            AxisAlignedBB current = this.getCurrentBox();
            if (current == null) {
                throw new IllegalStateException("Can not expand current box, if current is not set.");
            }
            AxisAlignedBB expanded = current.func_111270_a(entryData);
            Collection currentlyAssignedToCurrent = this.stateAssignments.removeAll((Object)current);
            currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((Vector3d)v, expanded));
            this.stateAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
            this.boxAssignments.put(centerPoint, expanded);
            this.stateAssignments.put((Object)expanded, (Object)centerPoint);
            this.currentBox = expanded;
        }

        public Collection<AxisAlignedBB> getBoxes() {
            return this.stateAssignments.keySet();
        }

        public void expandBoxAt(Vector3d neighborCenter, AxisAlignedBB entryData, Vector3d centerPoint) {
            AxisAlignedBB current = this.boxAssignments.get(neighborCenter);
            if (current == null) {
                throw new IllegalStateException(String.format("Can not expand box at: %s, if current is not set.", neighborCenter));
            }
            AxisAlignedBB expanded = current.func_111270_a(entryData);
            Collection currentlyAssignedToCurrent = this.stateAssignments.removeAll((Object)current);
            currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((Vector3d)v, expanded));
            this.stateAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
            this.boxAssignments.put(centerPoint, expanded);
            this.stateAssignments.put((Object)expanded, (Object)centerPoint);
        }
    }
}

