/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.carving;

import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import team.chisel.common.util.NonnullType;
import team.chisel.common.util.Point2i;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IChiselMode {
    public static final ResourceLocation SPRITES = new ResourceLocation("chisel", "textures/mode_icons.png");

    public Iterable<@NonnullType ? extends BlockPos> getCandidates(PlayerEntity var1, BlockPos var2, Direction var3);

    public AxisAlignedBB getBounds(Direction var1);

    public String name();

    default public String getUnlocName() {
        return "chisel.mode." + this.name().toLowerCase(Locale.ROOT);
    }

    default public String getUnlocDescription() {
        return this.getUnlocName() + ".desc";
    }

    default public ITextComponent getLocalizedName() {
        return new TranslationTextComponent(this.getUnlocName());
    }

    default public ITextComponent getLocalizedDescription() {
        return new TranslationTextComponent(this.getUnlocDescription());
    }

    default public long[] getCacheState(BlockPos origin, Direction side) {
        return new long[]{origin.func_218275_a(), side.ordinal()};
    }

    default public ResourceLocation getSpriteSheet() {
        return SPRITES;
    }

    public Point2i getSpritePos();
}

