/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.handler;

import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.StandardConfigFile;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;

public class ChickenChunksConfig {
    private static ConfigTag config;
    private static ConfigTag playerRestrictions;
    private static final Map<UUID, Restrictions> perPlayerRestrictions;
    private static boolean opsBypassRestrictions;
    private static boolean opsAccessAllLoaders;
    private static boolean globalAllowOffline;
    private static int globalOfflineTimeout;
    private static int globalTotalAllowedChunks;
    private static int globalChunksPerLoader;

    public static void load() {
        config = new StandardConfigFile(Paths.get("./config/ChickenChunks.cfg", new String[0])).load();
        opsBypassRestrictions = config.getTag("opsBypassRestrictions").setComment("If Players with OP permissions bypass chunk loading restrictions.").setDefaultBoolean(false).getBoolean();
        opsAccessAllLoaders = config.getTag("opsAccessAllLoaders").setComment("If Players with OP permissions can manage other users ChunkLoaders").setDefaultBoolean(true).getBoolean();
        globalAllowOffline = config.getTag("allowOffline").setComment("If chunks should stay loaded when a ChunkLoader's owner is offline.").setDefaultBoolean(true).getBoolean();
        globalOfflineTimeout = config.getTag("offlineTimeout").setComment("How long in minutes ChickenChunks should wait after a Player logs out to unload their chunks. Only effective when allowOffline=false").setDefaultInt(0).getInt();
        globalTotalAllowedChunks = config.getTag("totalAllowedChunks").setComment("The number of chunks each player is allowed to load in total.").setDefaultInt(5000).getInt();
        globalChunksPerLoader = config.getTag("chunksPerLoader").setComment("The number of chunks each ChunkLoader is allowed to load in total.").setDefaultInt(400).getInt();
        playerRestrictions = config.getTag("playerRestrictions").setSyncToClient().setComment("Specifies restrictions for each player, Use /chickenchunks instead.");
        playerRestrictions.setSyncCallback((tag, syncType) -> {
            perPlayerRestrictions.clear();
            for (String uuidString : tag.getChildNames()) {
                ConfigTag playerTag = tag.getTag(uuidString);
                UUID uuid = UUID.fromString(uuidString);
                perPlayerRestrictions.put(uuid, new Restrictions(playerTag));
            }
        });
        config.save();
        playerRestrictions.runSync();
    }

    public static boolean doesBypassRestrictions(MinecraftServer server, UUID playerUUID) {
        ServerPlayerEntity player = server.func_184103_al().func_177451_a(playerUUID);
        if (player != null && server.func_184103_al().func_152603_m().func_152692_d((Object)player.func_146103_bH())) {
            return opsBypassRestrictions;
        }
        return false;
    }

    public static boolean doesBypassLoaderAccess(ServerPlayerEntity player) {
        if (player.func_184102_h().func_184103_al().func_152603_m().func_152692_d((Object)player.func_146103_bH())) {
            return opsAccessAllLoaders;
        }
        return false;
    }

    public static Restrictions getOrCreateRestrictions(UUID player) {
        return perPlayerRestrictions.computeIfAbsent(player, e -> {
            ConfigTag tag = playerRestrictions.getTag(player.toString()).markDirty();
            tag.save();
            return new Restrictions(tag);
        });
    }

    public static void resetRestrictions(UUID player) {
        perPlayerRestrictions.remove(player);
        playerRestrictions.deleteTag(player.toString());
        playerRestrictions.save();
    }

    public static Restrictions getRestrictions(UUID player) {
        return perPlayerRestrictions.getOrDefault(player, Restrictions.EMPTY);
    }

    static {
        perPlayerRestrictions = new HashMap<UUID, Restrictions>();
    }

    public static class Restrictions {
        public static final Restrictions EMPTY = new Restrictions();
        private Optional<Boolean> allowOffline = Optional.empty();
        private Optional<Integer> offlineTimeout = Optional.empty();
        private Optional<Integer> totalAllowedChunks = Optional.empty();
        private Optional<Integer> chunksPerLoader = Optional.empty();
        private ConfigTag tag;

        public Restrictions() {
        }

        public Restrictions(ConfigTag tag) {
            this.tag = tag;
            this.allowOffline = Optional.ofNullable(tag.getTagIfPresent("allowOffline")).map(ConfigTag::getBoolean);
            this.offlineTimeout = Optional.ofNullable(tag.getTagIfPresent("offlineTimeout")).map(ConfigTag::getInt);
            this.totalAllowedChunks = Optional.ofNullable(tag.getTagIfPresent("totalAllowedChunks")).map(ConfigTag::getInt);
            this.chunksPerLoader = Optional.ofNullable(tag.getTagIfPresent("chunksPerLoader")).map(ConfigTag::getInt);
        }

        public boolean canLoadOffline() {
            return this.allowOffline.orElse(globalAllowOffline);
        }

        public int getOfflineTimeout() {
            return this.offlineTimeout.orElse(globalOfflineTimeout);
        }

        public int getTotalAllowedChunks() {
            return this.totalAllowedChunks.orElse(globalTotalAllowedChunks);
        }

        public int getChunksPerLoader() {
            return this.chunksPerLoader.orElse(globalChunksPerLoader);
        }

        public void setAllowOffline(boolean state) {
            this.tag.getTag("allowOffline").setBoolean(state).save();
            this.allowOffline = Optional.of(state);
        }

        public void setOfflineTimeout(int num) {
            this.tag.getTag("offlineTimeout").setInt(num).save();
            this.offlineTimeout = Optional.of(num);
        }

        public void setTotalAllowedChunks(int num) {
            this.tag.getTag("totalAllowedChunks").setInt(num).save();
            this.totalAllowedChunks = Optional.of(num);
        }

        public void setChunksPerLoader(int num) {
            this.tag.getTag("chunksPerLoader").setInt(num).save();
            this.chunksPerLoader = Optional.of(num);
        }

        public void remAllowOffline() {
            this.tag.deleteTag("allowOffline").save();
            this.allowOffline = Optional.empty();
        }

        public void remOfflineTimeout() {
            this.tag.deleteTag("offlineTimeout").save();
            this.offlineTimeout = Optional.empty();
        }

        public void remTotalAllowedChunks() {
            this.tag.deleteTag("totalAllowedChunks").save();
            this.totalAllowedChunks = Optional.empty();
        }

        public void remChunksPerLoader() {
            this.tag.deleteTag("chunksPerLoader").save();
            this.chunksPerLoader = Optional.empty();
        }

        public boolean isEmpty() {
            return !this.allowOffline.isPresent() && !this.offlineTimeout.isPresent() && !this.totalAllowedChunks.isPresent() && !this.chunksPerLoader.isPresent();
        }
    }
}

