/*
 * Decompiled with CFR 0.152.
 */
package chessmod.tileentity;

import chessmod.common.dom.model.chess.board.Board;
import chessmod.common.dom.model.chess.board.BoardFactory;
import chessmod.common.dom.model.chess.board.SerializedBoard;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ChessboardTileEntity
extends TileEntity {
    protected Board board = BoardFactory.createBoard();

    public Board getBoard() {
        return this.board;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onLoad() {
        super.onLoad();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public ChessboardTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        long pieceMask = compound.func_74763_f("piece_mask");
        long[] pieces = compound.func_197645_o("pieces");
        long[] moves = compound.func_197645_o("moves");
        this.board = pieceMask == 0L && pieces.length == 0 ? BoardFactory.createBoard() : new SerializedBoard(pieceMask, pieces, moves).deSerialize();
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        SerializedBoard sb = SerializedBoard.serialize(this.board);
        compound.func_74772_a("piece_mask", sb.piece_mask.longValue());
        compound.func_197644_a("pieces", sb.pieces);
        compound.func_197644_a("moves", sb.moves);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 42, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundNBT tag = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), tag);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        this.func_189515_b(tag);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(this.func_195044_w(), tag);
    }

    public void notifyClientOfBoardChange() {
        SUpdateTileEntityPacket packet = this.func_189518_D_();
        if (packet != null && this.func_145831_w() instanceof ServerWorld) {
            ((ServerChunkProvider)this.func_145831_w().func_72863_F()).field_217237_a.func_219097_a(new ChunkPos(this.func_174877_v()), false).forEach(e -> e.field_71135_a.func_147359_a((IPacket)packet));
        }
    }
}

