/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.dom.model.chess.piece;

import chessmod.common.dom.model.chess.Move;
import chessmod.common.dom.model.chess.PieceInitializer;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.board.Board;
import chessmod.common.dom.model.chess.piece.InvalidMoveException;
import chessmod.common.dom.model.chess.piece.Piece;
import java.util.HashSet;
import java.util.Set;

public class Pawn
extends Piece {
    public static char WHITE_SYMBOL = (char)80;
    public static char BLACK_SYMBOL = (char)112;
    int singleAdvance;
    int doubleAdvance;

    public Pawn(Point position, Side side) {
        super(position, side);
        this.singleAdvance = side.equals((Object)Side.BLACK) ? -1 : 1;
        this.doubleAdvance = side.equals((Object)Side.BLACK) ? -2 : 2;
    }

    public int getSingleAdvance() {
        return this.singleAdvance;
    }

    public int getDoubleAdvance() {
        return this.doubleAdvance;
    }

    @Override
    public Set<Move> getMovesFinalThreatNotwithstanding(Board b) throws InvalidMoveException {
        Set<Move> possible = super.getMovesFinalThreatNotwithstanding(b);
        b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_ONLY, 0, this.singleAdvance).forEach(p -> {
            if (p.y == (this.getSide().equals((Object)Side.BLACK) ? 0 : 7)) {
                possible.add(this.createPromotionMove(b, (Point)p, null));
            } else {
                possible.add(this.createMove(b, (Point)p));
            }
        });
        if (!this.hasMoved() && !possible.isEmpty()) {
            b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_ONLY, 0, this.doubleAdvance).forEach(p -> possible.add(this.createMove(b, (Point)p)));
        }
        if (!b.getMoves().isEmpty() && b.getMoves().get(b.getMoves().size() - 1) instanceof Move.PawnDoubleAdvance) {
            Move.PawnDoubleAdvance p2 = (Move.PawnDoubleAdvance)b.getMoves().get(b.getMoves().size() - 1);
            Point behindPawn = p2.getTarget().toY(this.singleAdvance);
            Point left = this.getPosition().toX(-1).toY(this.singleAdvance);
            if (!(left instanceof Point.InvalidPoint) && left.equals(behindPawn)) {
                possible.add(this.createMove(b, left));
            } else {
                Point right = this.getPosition().toX(1).toY(this.singleAdvance);
                if (!(right instanceof Point.InvalidPoint) && right.equals(behindPawn)) {
                    possible.add(this.createMove(b, right));
                }
            }
        }
        return possible;
    }

    @Override
    public Set<Point> getPossibleThreat(Board b) {
        HashSet<Point> possible = new HashSet<Point>();
        b.findTargettablePoint((Piece)this, Board.MoveType.ATTACK_ONLY, -1, this.singleAdvance).forEach(p -> {
            if (b.pieceAt((Point)p) != null) {
                possible.add((Point)p);
            }
        });
        b.findTargettablePoint((Piece)this, Board.MoveType.ATTACK_ONLY, 1, this.singleAdvance).forEach(p -> {
            if (b.pieceAt((Point)p) != null) {
                possible.add((Point)p);
            }
        });
        return possible;
    }

    @Override
    public char getCharacter() {
        return this.getSide().equals((Object)Side.WHITE) ? WHITE_SYMBOL : BLACK_SYMBOL;
    }

    @Override
    public int serialize() {
        int ser = PieceInitializer.P.ordinal();
        ser <<= 1;
        return ser |= this.getSide().ordinal();
    }

    @Override
    public Move createMove(Board b, Point t) {
        if (this.getPosition().x != t.x && b.isEmptySquare(t)) {
            return Move.createEnPassant(this, t);
        }
        if (!this.hasMoved() && this.getPosition().toY((int)this.getDoubleAdvance()).y == t.y) {
            return Move.createPawnDoubleAdvance(this);
        }
        if (t.y == (this.getSide().equals((Object)Side.BLACK) ? 0 : 7)) {
            return this.createPromotionMove(b, t, null);
        }
        return super.createMove(b, t);
    }

    public Move createPromotionMove(Board b, Point t, Piece p) {
        return Move.createPawnPromotion(this, t, p);
    }

    @Override
    public boolean hasMoved() {
        return this.getSide().equals((Object)Side.BLACK) ? this.getPosition().y != 6 : this.getPosition().y != 1;
    }
}

