/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.dom.model.chess.piece;

import chessmod.common.dom.model.chess.PieceInitializer;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.board.Board;
import chessmod.common.dom.model.chess.piece.Piece;
import java.util.HashSet;
import java.util.Set;

public class Knight
extends Piece {
    public static char WHITE_SYMBOL = (char)78;
    public static char BLACK_SYMBOL = (char)110;

    public Knight(Point position, Side side) {
        super(position, side);
    }

    @Override
    public Set<Point> getPossibleThreat(Board b) {
        HashSet<Point> possible = new HashSet<Point>();
        possible.addAll(b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_OR_ATTACK, Point.Directions.NORTH, Point.Directions.NORTH_WEST));
        possible.addAll(b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_OR_ATTACK, Point.Directions.NORTH, Point.Directions.NORTH_EAST));
        possible.addAll(b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_OR_ATTACK, Point.Directions.EAST, Point.Directions.NORTH_EAST));
        possible.addAll(b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_OR_ATTACK, Point.Directions.EAST, Point.Directions.SOUTH_EAST));
        possible.addAll(b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_OR_ATTACK, Point.Directions.SOUTH, Point.Directions.SOUTH_EAST));
        possible.addAll(b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_OR_ATTACK, Point.Directions.SOUTH, Point.Directions.SOUTH_WEST));
        possible.addAll(b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_OR_ATTACK, Point.Directions.WEST, Point.Directions.SOUTH_WEST));
        possible.addAll(b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_OR_ATTACK, Point.Directions.WEST, Point.Directions.NORTH_WEST));
        return possible;
    }

    @Override
    public char getCharacter() {
        return this.getSide().equals((Object)Side.WHITE) ? WHITE_SYMBOL : BLACK_SYMBOL;
    }

    @Override
    public int serialize() {
        int ser = PieceInitializer.N.ordinal();
        ser <<= 1;
        return ser |= this.getSide().ordinal();
    }
}

