/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.dom.model.chess.piece;

import chessmod.common.dom.model.chess.Move;
import chessmod.common.dom.model.chess.PieceInitializer;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.board.Board;
import chessmod.common.dom.model.chess.piece.InvalidMoveException;
import chessmod.common.dom.model.chess.piece.Piece;
import java.util.HashSet;
import java.util.Set;

public class King
extends Piece {
    public static char WHITE_SYMBOL = (char)75;
    public static char BLACK_SYMBOL = (char)107;

    public King(Point position, Side side) {
        super(position, side);
    }

    @Override
    public Set<Move> getMovesFinalThreatNotwithstanding(Board b) throws InvalidMoveException {
        Set<Move> possible = super.getMovesFinalThreatNotwithstanding(b);
        if (!this.hasMoved()) {
            Piece rightRook;
            Piece leftRook = b.pieceAt(Point.create(this.getPosition(), -4, 0));
            if (leftRook != null && !leftRook.hasMoved()) {
                b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_ONLY, -1, 0).forEach(p1 -> b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_ONLY, -2, 0).forEach(p2 -> b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_ONLY, -3, 0).forEach(p3 -> {
                    if (!b.isUnderThreatBy(this.getPosition().toX(-1), this.getSide().other())) {
                        possible.add(Move.createCastle(this, p2));
                    }
                })));
            }
            if ((rightRook = b.pieceAt(Point.create(this.getPosition(), 3, 0))) != null && !rightRook.hasMoved()) {
                b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_ONLY, 1, 0).forEach(p1 -> b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_ONLY, 2, 0).forEach(p2 -> {
                    if (!b.isUnderThreatBy(this.getPosition().toX(1), this.getSide().other())) {
                        possible.add(Move.createCastle(this, p2));
                    }
                }));
            }
        }
        return possible;
    }

    @Override
    public Set<Point> getPossibleThreat(Board b) {
        HashSet<Point> possible = new HashSet<Point>();
        for (Point.Directions d : Point.Directions.values()) {
            possible.addAll(b.findTargettablePoint((Piece)this, Board.MoveType.MOVE_OR_ATTACK, d));
        }
        return possible;
    }

    @Override
    public char getCharacter() {
        return this.getSide().equals((Object)Side.WHITE) ? WHITE_SYMBOL : BLACK_SYMBOL;
    }

    @Override
    public int serialize() {
        int ser = this.hasMoved() ? PieceInitializer.mK.ordinal() : PieceInitializer.nmK.ordinal();
        ser <<= 1;
        return ser |= this.getSide().ordinal();
    }

    @Override
    public Move createMove(Board b, Point t) {
        if (this.getPosition().toX((int)-2).x == t.x || this.getPosition().toX((int)2).x == t.x) {
            return Move.createCastle(this, t);
        }
        return super.createMove(b, t);
    }
}

