/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.dom.model.chess.board;

import chessmod.ChessMod;
import chessmod.common.dom.model.chess.InvalidPointException;
import chessmod.common.dom.model.chess.Move;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.board.SerializedBoard;
import chessmod.common.dom.model.chess.piece.InvalidMoveException;
import chessmod.common.dom.model.chess.piece.King;
import chessmod.common.dom.model.chess.piece.Piece;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Board {
    Piece[][] pieces = new Piece[8][8];
    List<Move> moves = new LinkedList<Move>();

    public Side getCurrentPlayer() {
        return this.moves.size() % 2 == 0 ? Side.BLACK : Side.WHITE;
    }

    public List<Move> getMoves() {
        return this.moves;
    }

    public void setMoves(List<Move> moves) {
        this.moves = moves;
    }

    private String showBoardPieceMask(SerializedBoard b) {
        BitSet pieceMaskSet = BitSet.valueOf(new long[]{b.piece_mask});
        StringBuilder sb = new StringBuilder("Deserializing board with mask: \n");
        for (int y = 0; y < 8; ++y) {
            long pieceBits = pieceMaskSet.get(y * 8, (y + 1) * 8).toLongArray().length == 1 ? pieceMaskSet.get(y * 8, (y + 1) * 8).toLongArray()[0] : 0L;
            sb.insert(0, String.format("%8s", Long.toUnsignedString(pieceBits, 2)).replace(' ', '0') + "\n");
        }
        return sb.toString();
    }

    public String showBoard() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                Piece p = this.pieceAt(Point.create(x, y));
                sb.append(p == null ? (char)'.' : (char)p.getCharacter());
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public Point getCheck() {
        if (this.isUnderThreatBy(this.getCurrentPlayer().other())) {
            return this.getKing(this.getCurrentPlayer()).getPosition();
        }
        return null;
    }

    public Point getCheckMate() {
        Side s = this.getCurrentPlayer();
        if (this.isUnderThreatBy(s.other())) {
            HashSet<Move> moves = new HashSet<Move>();
            for (int y = 0; y < 8; ++y) {
                for (int x = 0; x < 8; ++x) {
                    Piece piece = this.pieces[y][x];
                    if (piece == null || !piece.getSide().equals((Object)s)) continue;
                    try {
                        moves.addAll(piece.getAllowedMoves(this));
                        continue;
                    }
                    catch (InvalidMoveException e) {
                        ChessMod.LOGGER.error("Invlaid move while attempting to get Checkmate status");
                    }
                }
            }
            if (moves.isEmpty()) {
                return this.getKing(this.getCurrentPlayer()).getPosition();
            }
        }
        return null;
    }

    public Set<Point> findTargettablePointRun(Piece source, Point.Directions ... dirs) {
        int x = 0;
        int y = 0;
        for (Point.Directions d : dirs) {
            x += d.x;
            y += d.y;
        }
        return this.findTargettablePointRun(source, x, y);
    }

    public Set<Point> findTargettablePointRun(Piece source, int offsetX, int offsetY) {
        HashSet<Point> valid = new HashSet<Point>();
        Point p = Point.create(source.getPosition(), offsetX, offsetY);
        while (!(p instanceof Point.InvalidPoint || this.pieceAt(p) != null && this.pieceAt(p).getSide() == source.getSide())) {
            valid.add(p);
            if (this.pieceAt(p) != null) break;
            p = Point.create(p, offsetX, offsetY);
        }
        return valid;
    }

    public boolean isEmptySquare(int x, int y) {
        return this.isEmptySquare(Point.create(x, y));
    }

    public boolean isEmptySquare(Point p) {
        if (p instanceof Point.InvalidPoint) {
            throw new InvalidPointException();
        }
        return this.pieces[p.y][p.x] == null;
    }

    public Piece pieceAt(int x, int y) {
        return this.pieceAt(Point.create(x, y));
    }

    public Piece pieceAt(Point p) {
        if (p instanceof Point.InvalidPoint) {
            throw new InvalidPointException();
        }
        return this.pieces[p.y][p.x];
    }

    public void setPiece(Piece piece, Point p) {
        this.pieces[p.y][p.x] = piece;
        if (piece != null) {
            piece.setPosition(p);
        }
    }

    public Set<Point> findTargettablePoint(Piece source, MoveType type, Point.Directions ... dirs) {
        int x = 0;
        int y = 0;
        for (Point.Directions d : dirs) {
            x += d.x;
            y += d.y;
        }
        return this.findTargettablePoint(source, type, x, y);
    }

    public Set<Point> findTargettablePoint(Piece source, MoveType type, int offsetX, int offsetY) {
        HashSet<Point> valid = new HashSet<Point>();
        Point p = Point.create(source.getPosition(), offsetX, offsetY);
        if (!(p instanceof Point.InvalidPoint)) {
            Piece pieceAt = this.pieceAt(p);
            if ((type.equals((Object)MoveType.MOVE_ONLY) || type.equals((Object)MoveType.MOVE_OR_ATTACK)) && pieceAt == null || (type.equals((Object)MoveType.ATTACK_ONLY) || type.equals((Object)MoveType.MOVE_OR_ATTACK)) && pieceAt != null && !source.getSide().equals((Object)pieceAt.getSide())) {
                valid.add(p);
            }
        }
        return valid;
    }

    public boolean isUnderThreatBy(Point p, Side s) {
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                Piece piece = this.pieces[y][x];
                if (piece == null || !piece.getSide().equals((Object)s) || !piece.getPossibleThreat(this).contains(p)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUnderThreatBy(Side s) {
        Point p = this.getKing(s.other()).getPosition();
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                Set<Point> possibleThreats;
                Piece piece = this.pieces[y][x];
                if (piece == null || !piece.getSide().equals((Object)s) || !(possibleThreats = piece.getPossibleThreat(this)).contains(p)) continue;
                return true;
            }
        }
        return false;
    }

    public Piece getKing(Side s) {
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                Piece piece = this.pieces[y][x];
                if (piece == null || !piece.getSide().equals((Object)s) || !(piece instanceof King)) continue;
                return piece;
            }
        }
        return null;
    }

    public void moveSafely(Move m) throws InvalidMoveException {
        if (this.pieceAt(m.getSource()) == null) {
            throw new InvalidMoveException("Null source detected for move " + m);
        }
        if (!this.pieceAt(m.getSource()).getAllowedMoves(this).contains(m)) {
            throw new InvalidMoveException(m + " was not in the list of possible moves");
        }
        m.doMove(this);
        this.moves.add(m);
    }

    public void move(Move m) throws InvalidMoveException {
        m.doMove(this);
        this.moves.add(m);
    }

    public static enum MoveType {
        MOVE_ONLY,
        ATTACK_ONLY,
        MOVE_OR_ATTACK;

    }
}

