/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.dom.model.chess;

import chessmod.common.dom.model.chess.PieceInitializer;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.SpecialCase;
import chessmod.common.dom.model.chess.board.Board;
import chessmod.common.dom.model.chess.piece.King;
import chessmod.common.dom.model.chess.piece.Pawn;
import chessmod.common.dom.model.chess.piece.Piece;

public class Move {
    private Point source;
    private Point target;

    public Point getSource() {
        return this.source;
    }

    public Point getTarget() {
        return this.target;
    }

    protected Move(Point source, Point target) {
        this.source = source;
        this.target = target;
    }

    public static Move create(int serialized, Board b) {
        Point source = Point.create(serialized >>> 10 & 0x3F);
        Point target = Point.create(serialized >>> 4 & 0x3F);
        if ((serialized & 0xF) > 0) {
            if (source.y == target.y) {
                return Move.createCastle(source, target);
            }
            if (target.y == 0 || target.y == 7) {
                Piece p = PieceInitializer.create(target, serialized);
                return Move.createPawnPromotion(source, target, p);
            }
            if (Math.abs(source.y - target.y) == 2) {
                return Move.createPawnDoubleAdvance(source, target);
            }
            return Move.createEnPassant(source, target);
        }
        return Move.create(source, target);
    }

    public static Move create(Point source, Point target) {
        return new Move(source, target);
    }

    public static Move createCastle(King k, Point target) {
        Point source = k.getPosition();
        return Move.createCastle(source, target);
    }

    public static Move createCastle(Point source, Point target) {
        return new Castle(source, target);
    }

    public static Move createPawnDoubleAdvance(Pawn p) {
        Point source = p.getPosition();
        Point target = Point.create(source, 0, p.getDoubleAdvance());
        return Move.createPawnDoubleAdvance(source, target);
    }

    public static Move createPawnDoubleAdvance(Point source, Point target) {
        return new PawnDoubleAdvance(source, target);
    }

    public static Move createPawnPromotion(Pawn p, Point target, Piece promotion) {
        Point source = p.getPosition();
        return Move.createPawnPromotion(source, target, promotion);
    }

    public static Move createPawnPromotion(Point source, Point target, Piece promotion) {
        return new PawnPromotion(source, target, promotion);
    }

    public static Move createEnPassant(Pawn p, Point target) {
        Point source = p.getPosition();
        return Move.createEnPassant(source, target);
    }

    public static Move createEnPassant(Point source, Point target) {
        return new EnPassant(source, target);
    }

    public void doMove(Board b) {
        Piece p = b.pieceAt(this.getSource());
        p.setMoved(true);
        b.setPiece(null, this.getSource());
        b.setPiece(p, this.getTarget());
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.source.equals(((Move)obj).source) && this.target.equals(((Move)obj).target);
    }

    public String toString() {
        return "Move from " + this.source + " to " + this.target;
    }

    public int hashCode() {
        return this.serialize();
    }

    public int serialize() {
        int ser = 0;
        ser |= this.source.serialize();
        ser <<= 6;
        ser |= this.target.serialize();
        return ser <<= 4;
    }

    @SpecialCase
    public static class Castle
    extends Move {
        private Castle(Point source, Point target) {
            super(source, target);
        }

        @Override
        public void doMove(Board b) {
            super.doMove(b);
            boolean kingCastle = this.getSource().x < this.getTarget().x;
            Point oldRookPos = Point.create(kingCastle ? 7 : 0, this.getTarget().y);
            Point newRookPos = this.getTarget().toX(kingCastle ? -1 : 1);
            b.setPiece(b.pieceAt(oldRookPos), newRookPos);
            b.setPiece(null, oldRookPos);
        }

        @Override
        public String toString() {
            return super.toString() + " performing Castling ";
        }

        @Override
        public int serialize() {
            return super.serialize() | 1;
        }
    }

    @SpecialCase
    public static class EnPassant
    extends Move {
        private EnPassant(Point source, Point target) {
            super(source, target);
        }

        @Override
        public void doMove(Board b) {
            super.doMove(b);
            Pawn p = (Pawn)b.pieceAt(this.getTarget());
            Point pointToClear = Point.create(this.getTarget(), 0, -p.getSingleAdvance());
            b.setPiece(null, pointToClear);
        }

        @Override
        public int serialize() {
            return super.serialize() | 1;
        }

        @Override
        public String toString() {
            return super.toString() + " performing En Passant";
        }
    }

    @SpecialCase
    public static class PawnPromotion
    extends Move {
        Piece promotion;

        public Piece getPromotion() {
            return this.promotion;
        }

        private PawnPromotion(Point source, Point target, Piece promotion) {
            super(source, target);
            this.promotion = promotion;
        }

        @Override
        public void doMove(Board b) {
            super.doMove(b);
            this.promotion.setPosition(this.getTarget());
            b.setPiece(this.promotion, this.getTarget());
        }

        @Override
        public int serialize() {
            return super.serialize() | (this.promotion == null ? 0 : this.promotion.serialize());
        }

        @Override
        public int hashCode() {
            return super.serialize();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && (this.promotion == null || ((PawnPromotion)obj).promotion == null || this.promotion.getSide().equals((Object)((PawnPromotion)obj).promotion.getSide()) && this.promotion.getClass().equals(((PawnPromotion)obj).promotion.getClass()));
        }

        @Override
        public String toString() {
            return super.toString() + " promoting to " + (this.promotion == null ? "unknown" : this.promotion.getClass().getSimpleName());
        }
    }

    @SpecialCase
    public static class PawnDoubleAdvance
    extends Move {
        private PawnDoubleAdvance(Point source, Point target) {
            super(source, target);
        }

        @Override
        public int serialize() {
            return super.serialize() | 1;
        }

        @Override
        public String toString() {
            return super.toString() + " performing Pawn Double Advance";
        }
    }
}

