/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.capability.elo;

import chessmod.common.capability.elo.IElo;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class EloProvider
implements ICapabilityProvider,
INBTSerializable<INBT> {
    protected final Capability<IElo> capability;
    protected final Direction facing;
    protected final IElo instance;
    protected final LazyOptional<IElo> lazyOptional;

    protected EloProvider(Capability<IElo> capability, @Nullable Direction facing, @Nullable IElo instance) {
        this.capability = capability;
        this.facing = facing;
        this.instance = instance;
        this.lazyOptional = this.instance != null ? LazyOptional.of(() -> this.instance) : LazyOptional.empty();
    }

    public INBT serializeNBT() {
        IElo instance = this.getInstance();
        if (instance == null) {
            return null;
        }
        if (this.getCapability() == null) {
            return new CompoundNBT();
        }
        return this.getCapability().writeNBT((Object)instance, this.getFacing());
    }

    public void deserializeNBT(INBT nbt) {
        IElo instance = this.getInstance();
        if (instance == null) {
            return;
        }
        this.getCapability().readNBT((Object)instance, this.getFacing(), nbt);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.getCapability() == null) {
            return LazyOptional.empty();
        }
        return this.getCapability().orEmpty(capability, this.lazyOptional);
    }

    public final Capability<IElo> getCapability() {
        return this.capability;
    }

    @Nullable
    public Direction getFacing() {
        return this.facing;
    }

    @Nullable
    public final IElo getInstance() {
        return this.instance;
    }
}

