/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.capability.elo;

import chessmod.common.capability.elo.Elo;
import chessmod.common.capability.elo.EloProvider;
import chessmod.common.capability.elo.IElo;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class EloCapability {
    @CapabilityInject(value=IElo.class)
    public static final Capability<IElo> ELO_CAPABILITY = null;
    public static final Direction DEFAULT_FACING = null;
    public static final ResourceLocation ID = new ResourceLocation("chessmod", "elo");
    private static final String ELO_TAG = "elo";
    private static final int INITIAL_ELO = 1000;

    public static void register() {
        CapabilityManager.INSTANCE.register(IElo.class, (Capability.IStorage)new Capability.IStorage<IElo>(){

            @Nullable
            public INBT writeNBT(Capability<IElo> capability, IElo instance, Direction side) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74768_a(EloCapability.ELO_TAG, instance.getElo());
                return tag;
            }

            public void readNBT(Capability<IElo> capability, IElo instance, Direction side, INBT nbt) {
                CompoundNBT tag = (CompoundNBT)nbt;
                int elo = tag.func_74762_e(EloCapability.ELO_TAG);
                if (elo == 0) {
                    instance.setElo(1000);
                } else {
                    instance.setElo(elo);
                }
            }
        }, () -> new Elo(1000));
        System.out.println("Finished Registering EloCapability");
    }

    public static LazyOptional<IElo> getElo(LivingEntity entity) {
        return entity.getCapability(ELO_CAPABILITY, DEFAULT_FACING);
    }

    public static ICapabilityProvider createProvider(IElo mana) {
        return new EloProvider(ELO_CAPABILITY, DEFAULT_FACING, mana);
    }

    @Mod.EventBusSubscriber(modid="chessmod")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                Elo elo = new Elo(1000);
                event.addCapability(ID, EloCapability.createProvider(elo));
            }
        }

        @SubscribeEvent
        public static void playerClone(PlayerEvent.Clone event) {
            EloCapability.getElo((LivingEntity)event.getOriginal()).ifPresent(oldElo -> EloCapability.getElo((LivingEntity)event.getPlayer()).ifPresent(newElo -> newElo.setElo(oldElo.getElo())));
        }
    }
}

