/*
 * Decompiled with CFR 0.152.
 */
package chessmod.client.render.tileentity;

import chessmod.common.Point2f;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.piece.Piece;
import chessmod.tileentity.ChessboardTileEntity;
import chessmod.tileentity.GoldChessboardTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class ChessboardTileEntityRenderer
extends TileEntityRenderer<ChessboardTileEntity> {
    public static final ResourceLocation black = new ResourceLocation("chessmod", "textures/block/black.png");
    public static final ResourceLocation white = new ResourceLocation("chessmod", "textures/block/white.png");
    public static final RenderType BLACK_PIECE;
    public static final RenderType WHITE_PIECE;
    public static final RenderType TURN_STATE;

    public ChessboardTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void draw2DRect(IVertexBuilder bufferbuilder, MatrixStack matrixStackIn, Point2f p1, Point2f p2, float r, float g, float b, float a) {
        Matrix4f model = matrixStackIn.func_227866_c_().func_227870_a_();
        bufferbuilder.func_227888_a_(model, p2.x, 1.001f, p1.y).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(model, p1.x, 1.001f, p1.y).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(model, p1.x, 1.001f, p2.y).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(model, p2.x, 1.001f, p2.y).func_227885_a_(r, g, b, a).func_181675_d();
    }

    protected void showTurnColor(IVertexBuilder bufferbuilder, MatrixStack matrixStackIn, Side s) {
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        float c = 0.0f;
        if (s.equals((Object)Side.WHITE)) {
            c = 1.0f;
        }
        float x1Outter = 0.1015625f;
        float x1Inner = 0.11328125f;
        float x2Inner = 0.88671875f;
        float x2Outter = 0.8984375f;
        float z1Outter = 0.1015625f;
        float z1Inner = 0.11328125f;
        float z2Inner = 0.88671875f;
        float z2Outter = 0.8984375f;
        Point2f p1 = new Point2f(x1Outter, z1Outter);
        Point2f p2 = new Point2f(x2Outter, z1Inner);
        this.draw2DRect(bufferbuilder, matrixStackIn, p1, p2, c, c, c, 1.0f);
        p2 = new Point2f(x1Inner, z2Outter);
        this.draw2DRect(bufferbuilder, matrixStackIn, p1, p2, c, c, c, 1.0f);
        p1 = new Point2f(x2Inner, z1Outter);
        p2 = new Point2f(x2Outter, z2Outter);
        this.draw2DRect(bufferbuilder, matrixStackIn, p1, p2, c, c, c, 1.0f);
        p1 = new Point2f(x1Outter, z2Inner);
        this.draw2DRect(bufferbuilder, matrixStackIn, p1, p2, c, c, c, 1.0f);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public void render(ChessboardTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer b, int combinedLightIn, int combinedOverlayIn) {
        Piece piece;
        int bx;
        int by;
        matrixStackIn.func_227860_a_();
        IVertexBuilder bufferbuilder = b.getBuffer(TURN_STATE);
        if (tileEntityIn instanceof GoldChessboardTileEntity) {
            this.showTurnColor(bufferbuilder, matrixStackIn, tileEntityIn.getBoard().getCurrentPlayer());
        }
        matrixStackIn.func_227865_b_();
        RenderSystem.disableCull();
        RenderSystem.enableTexture();
        matrixStackIn.func_227860_a_();
        bufferbuilder = b.getBuffer(BLACK_PIECE);
        for (by = 0; by < 8; ++by) {
            block17: for (bx = 0; bx < 8; ++bx) {
                piece = tileEntityIn.getBoard().pieceAt(Point.create(bx, by));
                if (piece == null) continue;
                switch (piece.getCharacter()) {
                    case 'r': {
                        this.drawRook(bx, by, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block17;
                    }
                    case 'n': {
                        this.drawKnight(bx, by, false, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block17;
                    }
                    case 'b': {
                        this.drawBishop(bx, by, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block17;
                    }
                    case 'q': {
                        this.drawQueen(bx, by, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block17;
                    }
                    case 'k': {
                        this.drawKing(bx, by, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block17;
                    }
                    case 'p': {
                        this.drawPawn(bx, by, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block17;
                    }
                }
            }
        }
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        bufferbuilder = b.getBuffer(WHITE_PIECE);
        for (by = 0; by < 8; ++by) {
            block19: for (bx = 0; bx < 8; ++bx) {
                piece = tileEntityIn.getBoard().pieceAt(Point.create(bx, by));
                if (piece == null) continue;
                switch (tileEntityIn.getBoard().pieceAt(Point.create(bx, by)).getCharacter()) {
                    case 'R': {
                        this.drawRook(bx, by, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block19;
                    }
                    case 'N': {
                        this.drawKnight(bx, by, true, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block19;
                    }
                    case 'B': {
                        this.drawBishop(bx, by, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block19;
                    }
                    case 'Q': {
                        this.drawQueen(bx, by, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block19;
                    }
                    case 'K': {
                        this.drawKing(bx, by, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block19;
                    }
                    case 'P': {
                        this.drawPawn(bx, by, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn);
                        continue block19;
                    }
                }
            }
        }
        matrixStackIn.func_227865_b_();
        RenderSystem.enableCull();
    }

    private void drawBishop(int bx, int bz, MatrixStack matrixStackIn, IVertexBuilder bufferbuilder, int combinedLightIn, int combinedOverlayIn) {
        this.drawPiece(0.02f, bx, bz, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn, 0.0, 0.0, 0.0);
        this.drawPiece(0.02f, bx, bz, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn, 0.0, 0.04, 0.0);
    }

    private void drawKnight(int bx, int bz, boolean flip, MatrixStack matrixStackIn, IVertexBuilder bufferbuilder, int combinedLightIn, int combinedOverlayIn) {
        float x = flip ? 0.01f : -0.01f;
        float z = flip ? -0.01f : 0.01f;
        this.drawPiece(0.02f, bx, bz, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn, x, 0.0, z);
        this.drawPiece(0.02f, bx, bz, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn, -x, 0.04, -z);
    }

    private void drawRook(int bx, int bz, MatrixStack matrixStackIn, IVertexBuilder bufferbuilder, int combinedLightIn, int combinedOverlayIn) {
        this.drawPiece(0.03f, bx, bz, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn, 0.0, 0.0, 0.0);
    }

    private void drawKing(int bx, int bz, MatrixStack matrixStackIn, IVertexBuilder bufferbuilder, int combinedLightIn, int combinedOverlayIn) {
        this.drawPiece(0.04f, bx, bz, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn, 0.0, 0.0, 0.0);
    }

    private void drawQueen(int bx, int bz, MatrixStack matrixStackIn, IVertexBuilder bufferbuilder, int combinedLightIn, int combinedOverlayIn) {
        this.drawPiece(0.03f, bx, bz, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn, 0.0, 0.0, 0.0);
        this.drawPiece(0.02f, bx, bz, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn, 0.0, 0.06, 0.0);
    }

    private void drawPawn(int bx, int bz, MatrixStack matrixStackIn, IVertexBuilder bufferbuilder, int combinedLightIn, int combinedOverlayIn) {
        this.drawPiece(0.02f, bx, bz, matrixStackIn, bufferbuilder, combinedLightIn, combinedOverlayIn, 0.0, 0.0, 0.0);
    }

    private void drawPiece(float size, int bx, int bz, MatrixStack matrixStackIn, IVertexBuilder bufferbuilder, int combinedLightIn, int overlay, double x, double y, double z) {
        float xOff = (float)(x + 0.171875 + (double)((float)bx * 1.5f / 16.0f));
        float yOff = (float)(y + 1.0 + (double)size);
        float zOff = (float)(z + 0.171875 + (double)((float)bz * 1.5f / 16.0f));
        float PieceTileSize = 240.0f;
        float PieceTileBorderSize = 12.0f;
        float UnitPieceSize = 0.04f;
        float scaledTextureOffset = (2.0f - 0.04f / size) / 2.0f * 12.0f / 240.0f;
        Matrix4f model = matrixStackIn.func_227866_c_().func_227870_a_();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff - size, zOff + size).func_225583_a_(1.0f - scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff + size, zOff + size).func_225583_a_(1.0f - scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff + size, zOff + size).func_225583_a_(scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff - size, zOff + size).func_225583_a_(scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff - size, zOff - size).func_225583_a_(1.0f - scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff + size, zOff - size).func_225583_a_(1.0f - scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff + size, zOff - size).func_225583_a_(scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff - size, zOff - size).func_225583_a_(scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff - size, zOff - size).func_225583_a_(1.0f - scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff + size, zOff - size).func_225583_a_(1.0f - scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff + size, zOff + size).func_225583_a_(scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff - size, zOff + size).func_225583_a_(scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff - size, zOff + size).func_225583_a_(1.0f - scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff + size, zOff + size).func_225583_a_(1.0f - scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff + size, zOff - size).func_225583_a_(scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff - size, zOff - size).func_225583_a_(scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff + size, zOff - size).func_225583_a_(1.0f - scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff + size, zOff - size).func_225583_a_(1.0f - scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff + size, zOff + size).func_225583_a_(scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff + size, zOff + size).func_225583_a_(scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff - size, zOff - size).func_225583_a_(1.0f - scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff - size, zOff - size).func_225583_a_(1.0f - scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff + size, yOff - size, zOff + size).func_225583_a_(scaledTextureOffset, scaledTextureOffset).func_181675_d();
        bufferbuilder.func_227888_a_(model, xOff - size, yOff - size, zOff + size).func_225583_a_(scaledTextureOffset, 1.0f - scaledTextureOffset).func_181675_d();
    }

    public boolean isGlobalRenderer(ChessboardTileEntity te) {
        return true;
    }

    static {
        RenderType.State glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(black, true, true)).func_228728_a_(true);
        BLACK_PIECE = RenderType.func_228632_a_((String)"chessmodpiece", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)64, (RenderType.State)glState);
        glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(white, true, true)).func_228728_a_(true);
        WHITE_PIECE = RenderType.func_228632_a_((String)"chessmodpiece", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)64, (RenderType.State)glState);
        glState = RenderType.State.func_228694_a_().func_228728_a_(true);
        TURN_STATE = RenderType.func_228632_a_((String)"chessmodturn", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)64, (RenderType.State)glState);
    }
}

