/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.mixins;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.dorianpb.cem.internal.models.CemModelPart;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.dorianpb.cem.internal.util.CemRegistryManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3887.class})
public abstract class FeatureRendererMixin {
    private static final Map<class_583<? extends class_1309>, Optional<CemModelRegistry>> textures = new WeakHashMap<class_583<? extends class_1309>, Optional<CemModelRegistry>>();

    @ModifyVariable(method={"renderModel"}, at=@At(value="HEAD"), index=1, argsOnly=true)
    private static <T extends class_1309> class_2960 cem$replaceFeatureRendererTexture(class_2960 texture, class_583<T> model) {
        Optional registry = textures.computeIfAbsent(model, FeatureRendererMixin::getRegistry);
        if (registry.isPresent() && ((CemModelRegistry)registry.get()).hasTexture()) {
            return ((CemModelRegistry)registry.get()).getTexture();
        }
        return texture;
    }

    @NotNull
    private static <T extends class_1309> Optional<CemModelRegistry> getRegistry(class_583<T> model) {
        Optional<Field> fieldOptional = Arrays.stream(model.getClass().getFields()).filter(field -> field.getType().equals(class_630.class)).findAny();
        if (fieldOptional.isPresent() && fieldOptional.get().canAccess(model)) {
            try {
                Object object;
                class_630 modelPart = (class_630)fieldOptional.get().get(model);
                if (modelPart instanceof CemModelPart && (object = ((CemModelPart)modelPart).getIdentifier()) instanceof class_5601) {
                    class_5601 layer = (class_5601)object;
                    return Optional.of(CemRegistryManager.getRegistry(layer));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    @Inject(method={"render(Lnet/minecraft/client/render/entity/model/EntityModel;Lnet/minecraft/client/render/entity/model/EntityModel;Lnet/minecraft/util/Identifier;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;setAngles(Lnet/minecraft/entity/Entity;FFFFF)V", shift=At.Shift.AFTER)})
    private static <T extends class_1309> void cem$applyCemAnimationsToFeatureRenderer(class_583<T> contextModel, class_583<T> model, class_2960 texture, class_4587 matrices, class_4597 vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float age, float headYaw, float headPitch, float tickDelta, float red, float green, float blue, CallbackInfo ci) {
        Optional registry = textures.computeIfAbsent(model, FeatureRendererMixin::getRegistry);
        registry.ifPresent(cemModelRegistry -> cemModelRegistry.applyAnimations(limbAngle, limbDistance, age, headYaw, headPitch, (class_1297)entity));
    }
}

