/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.mixins;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.function.Function;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.dorianpb.cem.internal.util.CemFairy;
import net.dorianpb.cem.internal.util.CemRegistryManager;
import net.dorianpb.cem.mixins.EntityRendererAccessor;
import net.dorianpb.cem.mixins.ModelAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_5619;
import net.minecraft.class_897;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_5619.class})
public abstract class EntityRenderersMixin {
    @Redirect(method={"method_32174"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableMap$Builder;put(Ljava/lang/Object;Ljava/lang/Object;)Lcom/google/common/collect/ImmutableMap$Builder;"))
    private static <K extends class_1299<?>, V extends class_897<?>> ImmutableMap.Builder<K, V> cem$prepareEntityRenderer(ImmutableMap.Builder<K, V> instance, Object key, Object value) {
        if (CemRegistryManager.hasEntity((class_1299<? extends class_1297>)((class_1299)key))) {
            CemModelRegistry registry = CemRegistryManager.getRegistry((class_1299<? extends class_1297>)((class_1299)key));
            if (registry.hasShadowRadius()) {
                ((EntityRendererAccessor)value).setShadowRadius(registry.getShadowRadius());
            }
            if (registry.hasTexture()) {
                try {
                    Field modelField = value.getClass().getField("model");
                    if (!class_3879.class.isAssignableFrom(modelField.getType())) {
                        throw new ClassCastException("Renderer " + value.getClass().getSimpleName() + " doesn't have a model that extends Model, can't assign texture!");
                    }
                    if (!modelField.canAccess(value)) {
                        throw new IllegalAccessException("Can't access the \"model\" field of " + value.getClass().getSimpleName() + ", can't assign texture!");
                    }
                    class_3879 model = (class_3879)modelField.get(value);
                    Function<class_2960, class_1921> function = ((ModelAccessor)model).getLayerFactory();
                    class_2960 texture = registry.getTexture();
                    ((ModelAccessor)model).setLayerFactory(identifier -> (class_1921)function.apply(texture));
                }
                catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    CemFairy.getLogger().error(e.getMessage());
                }
            }
        }
        return instance.put((Object)((class_1299)key), (Object)((class_897)value));
    }
}

