/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.mixins;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.LinkedTreeMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.dorianpb.cem.internal.config.CemConfigFairy;
import net.dorianpb.cem.internal.file.JemFile;
import net.dorianpb.cem.internal.util.CemFairy;
import net.dorianpb.cem.internal.util.CemRegistryManager;
import net.dorianpb.cem.internal.util.OptifineFixes;
import net.dorianpb.cem.mixins.EntityModelLayersAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_630;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_5599.class})
public abstract class EntityModelLoaderMixin {
    @Inject(method={"reload"}, at={@At(value="HEAD")})
    private void cem$injectReload(class_3300 manager, CallbackInfo ci) {
        CemRegistryManager.clearRegistries();
        manager.method_14488("cem/opticompat", path -> path.method_12832().endsWith(".json")).forEach((id, resource) -> EntityModelLoaderMixin.loadResourceFromId(id, resource, OptifineFixes::accept, OptifineFixes::accept, false));
        manager.method_14488("cem", path -> path.method_12832().endsWith(".jem") && !path.method_12832().startsWith("cem/opticompat")).forEach((id, resource) -> EntityModelLoaderMixin.loadResourceFromId(id, resource, (layer, json) -> EntityModelLoaderMixin.acceptJemFile(layer, (LinkedTreeMap<String, Object>)json, id, manager), (blockEntityType, json) -> EntityModelLoaderMixin.acceptJemFile((class_2591<? extends class_2586>)blockEntityType, (LinkedTreeMap<String, Object>)json, id, manager), true));
        if (CemConfigFairy.getConfig().useOptifineFolder()) {
            manager.method_14488("optifine/cem", path -> path.method_12832().endsWith(".jem") && path.method_12836().equals("minecraft")).forEach((id, resource) -> EntityModelLoaderMixin.loadResourceFromId(id, resource, (layer, json) -> EntityModelLoaderMixin.acceptJemFile(layer, (LinkedTreeMap<String, Object>)json, id, manager), (blockEntityType, json) -> EntityModelLoaderMixin.acceptJemFile((class_2591<? extends class_2586>)blockEntityType, (LinkedTreeMap<String, Object>)json, id, manager), true));
        }
    }

    private static void loadResourceFromId(class_2960 id, class_3298 resource, BiConsumer<class_5601, LinkedTreeMap<String, Object>> entityConsumer, BiConsumer<class_2591<? extends class_2586>, LinkedTreeMap<String, Object>> blockEntityConsumer, boolean logging) {
        block13: {
            if (logging) {
                CemFairy.getLogger().info(id.toString());
            }
            try (InputStream stream = resource.method_14482();){
                LinkedTreeMap json = (LinkedTreeMap)CemFairy.getGson().fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), LinkedTreeMap.class);
                if (json == null) {
                    throw new IOException("Invalid File");
                }
                String entityName = EntityModelLoaderMixin.getEntityNameFromId(id);
                Optional<class_5601> entityModelLayerOptional = EntityModelLoaderMixin.tryParseEntityModelLayer(id);
                Optional blockEntityTypeOptional = class_7923.field_41181.method_17966(class_2960.method_12829((String)entityName));
                if (entityModelLayerOptional.isPresent()) {
                    class_5601 entityModelLayer = entityModelLayerOptional.get();
                    entityConsumer.accept(entityModelLayer, (LinkedTreeMap<String, Object>)json);
                    break block13;
                }
                if (blockEntityTypeOptional.isPresent()) {
                    class_2591 entityType = (class_2591)blockEntityTypeOptional.get();
                    blockEntityConsumer.accept((class_2591<? extends class_2586>)entityType, (LinkedTreeMap<String, Object>)json);
                    break block13;
                }
                throw new NoSuchElementException("Unknown object \"" + id.method_12836() + ":" + entityName + "\"!");
            }
            catch (JsonIOException | JsonSyntaxException | IOException | NoSuchElementException exception) {
                CemFairy.getLogger().error("Error parsing " + id + ":");
                String message = exception.getMessage();
                CemFairy.getLogger().error((Object)exception);
                if (message != null && !message.trim().isEmpty()) break block13;
                for (int i = 0; i < 3; ++i) {
                    CemFairy.getLogger().error((Object)exception.getStackTrace()[i]);
                }
            }
        }
    }

    private static void acceptJemFile(class_5601 entityModelLayer, LinkedTreeMap<String, Object> json, class_2960 id, class_3300 manager) {
        try {
            JemFile file = new JemFile(json, id, manager);
            CemRegistryManager.addRegistry(entityModelLayer, file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void acceptJemFile(class_2591<? extends class_2586> blockEntityType, LinkedTreeMap<String, Object> json, class_2960 id, class_3300 manager) {
        try {
            JemFile file = new JemFile(json, id, manager);
            CemFairy.getLogger().error("This build of CEM doesn't support Block Entities.");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getEntityNameFromId(class_2960 identifier) {
        String id = identifier.toString();
        return id.substring(id.lastIndexOf(47) + 1, id.lastIndexOf(46));
    }

    private static Optional<class_5601> tryParseEntityModelLayer(class_2960 id) {
        String idstr;
        String namespace = id.method_12836() + ":";
        Optional entityTypeOptional = class_1299.method_5898((String)(namespace + (idstr = EntityModelLoaderMixin.getEntityNameFromId(id))));
        if (entityTypeOptional.isPresent()) {
            return Optional.of(new class_5601(class_1299.method_5890((class_1299)((class_1299)entityTypeOptional.get())), EntityModelLayersAccessor.getMAIN()));
        }
        if (idstr.contains("_")) {
            String name = idstr.substring(0, idstr.lastIndexOf(95));
            String layer = idstr.substring(idstr.lastIndexOf(95) + 1);
            Optional entityTypeOptional2 = class_1299.method_5898((String)(namespace + name));
            if (entityTypeOptional2.isPresent()) {
                return Optional.of(new class_5601(class_1299.method_5890((class_1299)((class_1299)entityTypeOptional2.get())), layer));
            }
        }
        return Optional.empty();
    }

    @Inject(method={"getModelPart"}, at={@At(value="RETURN")}, cancellable=true)
    private void cem$getModelPart(class_5601 layer, CallbackInfoReturnable<class_630> cir) {
        if (CemRegistryManager.hasEntityLayer(layer)) {
            if (!OptifineFixes.hasFixesFor(layer)) {
                CemFairy.getLogger().warn("No fixes for " + layer);
            }
            cir.setReturnValue((Object)CemRegistryManager.getRegistry(layer).prepRootPart((class_630)cir.getReturnValue(), OptifineFixes.getPartNames(layer), OptifineFixes.getModelFixes(layer), layer));
        }
    }
}

