/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.util.stringparser;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.dorianpb.cem.internal.models.CemModelEntry;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.dorianpb.cem.internal.util.stringparser.Environment;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpression;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpressionBool;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpressionFloat;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunctionFloat;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunctionType;
import net.dorianpb.cem.internal.util.stringparser.Token;

class ParsedIf
implements ParsedFunctionFloat {
    private final List<ParsedExpressionBool> conditions;
    private final List<ParsedExpressionFloat> expressions;

    ParsedIf(Token token, CemModelRegistry registry, CemModelEntry parent) {
        if (token.getArgs() == null) {
            throw new IllegalArgumentException("\"" + token.getName() + "\" requires arguments!");
        }
        this.conditions = new ArrayList<ParsedExpressionBool>();
        this.expressions = new ArrayList<ParsedExpressionFloat>();
        for (int i = 0; i < token.getArgs().size(); ++i) {
            ParsedFunctionType wantedType;
            ParsedFunctionType parsedFunctionType = wantedType = i % 2 == 1 || i == token.getArgs().size() - 1 ? ParsedFunctionType.FLOAT : ParsedFunctionType.BOOL;
            if (wantedType == ParsedFunctionType.BOOL) {
                try {
                    this.conditions.add(new ParsedExpressionBool(token.getArgs().get(i), registry, parent));
                    continue;
                }
                catch (InvalidParameterException ignored) {
                    throw new IllegalArgumentException("\"" + token.getName() + "\" requires a bool for argument #" + (i + 1) + ", but a number was provided");
                }
            }
            try {
                this.expressions.add(new ParsedExpressionFloat(token.getArgs().get(i), registry, parent));
                continue;
            }
            catch (InvalidParameterException ignored) {
                throw new IllegalArgumentException("\"" + token.getName() + "\" requires a number for argument #" + (i + 1) + ", but a bool was provided");
            }
        }
        if (this.conditions.isEmpty()) {
            throw new IllegalArgumentException("\"" + token.getName() + "\" requires at least one condition!");
        }
        if (this.conditions.size() + 1 != this.expressions.size()) {
            throw new IllegalArgumentException("\"" + token.getName() + "\" is missing an \"val_else\" value, please add a number at the end.");
        }
    }

    @Override
    public float eval(ArrayList<ParsedExpression> args, Environment env) {
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!this.conditions.get(i).eval(env)) continue;
            return this.expressions.get(i).eval(env);
        }
        return this.expressions.get(this.expressions.size() - 1).eval(env);
    }

    @Override
    public int getArgNumber() {
        return -1;
    }
}

