/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.util.stringparser;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Map;
import net.dorianpb.cem.internal.models.CemModelEntry;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.dorianpb.cem.internal.util.stringparser.CemStringParser;
import net.dorianpb.cem.internal.util.stringparser.Environment;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpression;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunction;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunctionFloat;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunctionType;
import net.dorianpb.cem.internal.util.stringparser.ParsedIf;
import net.dorianpb.cem.internal.util.stringparser.Token;
import net.minecraft.class_1297;

public final class ParsedExpressionFloat
implements ParsedExpression {
    private final ParsedFunctionFloat operation;
    private final ArrayList<ParsedExpression> arguments;

    ParsedExpressionFloat(Token token, CemModelRegistry registry, CemModelEntry parent) {
        ParsedFunction temp = CemStringParser.matchToken(token, registry, parent);
        if (temp.getType() != ParsedFunctionType.FLOAT) {
            throw new InvalidParameterException("\"" + token.getName() + "\" is not a number and will not return a number!");
        }
        this.operation = (ParsedFunctionFloat)temp;
        if (token.getArgs() != null && this.operation.getClass() != ParsedIf.class) {
            this.arguments = new ArrayList();
            for (Token arg : token.getArgs()) {
                try {
                    this.arguments.add(new ParsedExpressionFloat(arg, registry, parent));
                }
                catch (InvalidParameterException ignored) {
                    throw new IllegalArgumentException("\"" + token.getName() + "\" requires numbers as arguments and \"" + arg.getName() + "\" is not a number!");
                }
            }
        } else {
            this.arguments = token.getArgs() != null ? new ArrayList() : null;
        }
        this.checkArgs(this.arguments, this.operation.getArgNumber());
    }

    public float eval(float limbAngle, float limbDistance, float age, float head_yaw, float head_pitch, class_1297 entity, Map<String, Boolean> boolanimvars, Map<String, Float> floatanimvars) {
        return this.eval(new Environment(limbAngle, limbDistance, age, head_yaw, head_pitch, entity, boolanimvars, floatanimvars));
    }

    float eval(Environment env) {
        return this.operation.eval(this.arguments, env);
    }

    @Override
    public ParsedFunctionType getType() {
        return ParsedFunctionType.FLOAT;
    }

    @Override
    public String getName() {
        return this.operation.toString();
    }
}

