/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.util.stringparser;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Map;
import net.dorianpb.cem.internal.models.CemModelEntry;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.dorianpb.cem.internal.util.stringparser.CemStringParser;
import net.dorianpb.cem.internal.util.stringparser.Environment;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpression;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpressionFloat;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunction;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunctionBool;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunctionType;
import net.dorianpb.cem.internal.util.stringparser.Token;
import net.minecraft.class_1297;

public final class ParsedExpressionBool
implements ParsedExpression {
    private final ParsedFunctionBool operation;
    private final ArrayList<ParsedExpression> arguments;

    ParsedExpressionBool(Token token, CemModelRegistry registry, CemModelEntry parent) {
        ParsedFunction temp = CemStringParser.matchToken(token, registry, parent);
        if (temp.getType() != ParsedFunctionType.BOOL) {
            throw new InvalidParameterException("\"" + token.getName() + "\" is not a number and will not return a number!");
        }
        this.operation = (ParsedFunctionBool)temp;
        if (token.getArgs() != null) {
            this.arguments = new ArrayList();
            for (Token arg : token.getArgs()) {
                if (this.operation.getArgType() == ParsedFunctionType.FLOAT) {
                    try {
                        this.arguments.add(new ParsedExpressionFloat(arg, registry, parent));
                        continue;
                    }
                    catch (InvalidParameterException ignored) {
                        throw new IllegalArgumentException("\"" + token.getName() + "\" requires numbers as arguments and \"" + arg.getName() + "\" is not a number!");
                    }
                }
                try {
                    this.arguments.add(new ParsedExpressionBool(arg, registry, parent));
                }
                catch (InvalidParameterException ignored) {
                    throw new IllegalArgumentException("\"" + token.getName() + "\" requires bools as arguments and \"" + arg.getName() + "\" is not a bool!");
                }
            }
        } else {
            this.arguments = null;
        }
        this.checkArgs(this.arguments, this.operation.getArgNumber());
    }

    public boolean eval(float limbAngle, float limbDistance, float age, float head_yaw, float head_pitch, class_1297 entity, Map<String, Boolean> boolanimvars, Map<String, Float> floatanimvars) {
        return this.eval(new Environment(limbAngle, limbDistance, age, head_yaw, head_pitch, entity, boolanimvars, floatanimvars));
    }

    boolean eval(Environment env) {
        return this.operation.eval(this.arguments, env);
    }

    @Override
    public ParsedFunctionType getType() {
        return ParsedFunctionType.BOOL;
    }

    @Override
    public String getName() {
        return this.operation.toString();
    }
}

