/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.util.stringparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.dorianpb.cem.internal.models.CemModelEntry;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.dorianpb.cem.internal.util.stringparser.BOOL_FUNCTION_BOOL;
import net.dorianpb.cem.internal.util.stringparser.BOOL_FUNCTION_FLOAT;
import net.dorianpb.cem.internal.util.stringparser.BOOL_PARAMETER;
import net.dorianpb.cem.internal.util.stringparser.FLOAT_FUNCTION;
import net.dorianpb.cem.internal.util.stringparser.FLOAT_PARAMETER;
import net.dorianpb.cem.internal.util.stringparser.NumToken;
import net.dorianpb.cem.internal.util.stringparser.ParsedEntityVarBool;
import net.dorianpb.cem.internal.util.stringparser.ParsedEntityVarFloat;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpression;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpressionBool;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpressionFloat;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunction;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunctionType;
import net.dorianpb.cem.internal.util.stringparser.ParsedIf;
import net.dorianpb.cem.internal.util.stringparser.ParsedNumber;
import net.dorianpb.cem.internal.util.stringparser.ParsedVar;
import net.dorianpb.cem.internal.util.stringparser.Token;

public final class CemStringParser
extends Enum<CemStringParser> {
    private static final Pattern ensure_whitespace_between_operators;
    private static final Pattern keep_exclamation_point_with_expression;
    private static final Pattern ensure_paran_whitespace;
    private static final Pattern merge_whitespace;
    private static final Pattern remove_sectionsign;
    private static final /* synthetic */ CemStringParser[] $VALUES;

    public static CemStringParser[] values() {
        return (CemStringParser[])$VALUES.clone();
    }

    public static CemStringParser valueOf(String name) {
        return Enum.valueOf(CemStringParser.class, name);
    }

    public static ParsedExpression parse(String expr, CemModelRegistry registry, CemModelEntry parent) {
        Token token = CemStringParser.initParseLoop(expr);
        ParsedFunction matched = CemStringParser.matchToken(token, registry, parent);
        if (matched.getType() == ParsedFunctionType.FLOAT) {
            return new ParsedExpressionFloat(token, registry, parent);
        }
        return new ParsedExpressionBool(token, registry, parent);
    }

    static ParsedFunction matchToken(Token token, CemModelRegistry registry, CemModelEntry parent) {
        if (token.getName().equals("NUM")) {
            try {
                return new ParsedNumber((NumToken)token);
            }
            catch (Exception ignored) {
                throw new IllegalArgumentException("Why is there a token named \"NUM\" that is not a NumToken?");
            }
        }
        if (token.getName().startsWith("var.")) {
            return new ParsedEntityVarFloat(token);
        }
        if (token.getName().startsWith("varb.")) {
            return new ParsedEntityVarBool(token);
        }
        if (token.getName().contains(".")) {
            return new ParsedVar(token, registry, parent);
        }
        if (token.getName().equalsIgnoreCase("if")) {
            return new ParsedIf(token, registry, parent);
        }
        try {
            return FLOAT_PARAMETER.valueOf(token.getName().toUpperCase());
        }
        catch (Exception exception) {
            try {
                return FLOAT_FUNCTION.valueOf(token.getName().toUpperCase());
            }
            catch (Exception exception2) {
                try {
                    return BOOL_PARAMETER.valueOf(token.getName().toUpperCase());
                }
                catch (Exception exception3) {
                    try {
                        return BOOL_FUNCTION_FLOAT.valueOf(token.getName().toUpperCase());
                    }
                    catch (Exception exception4) {
                        try {
                            return BOOL_FUNCTION_BOOL.valueOf(token.getName().toUpperCase());
                        }
                        catch (Exception exception5) {
                            throw new IllegalArgumentException("Unknown symbol \"" + token.getName() + "\"");
                        }
                    }
                }
            }
        }
    }

    private static Token initParseLoop(String input) {
        int i;
        ArrayList<String> work = new ArrayList<String>(Arrays.asList(remove_sectionsign.matcher(merge_whitespace.matcher(ensure_paran_whitespace.matcher(keep_exclamation_point_with_expression.matcher(ensure_whitespace_between_operators.matcher(input).replaceAll(" $1 ")).replaceAll(" ! $1")).replaceAll(" $1 ")).replaceAll(" ")).replaceAll("").trim().split(" ")));
        Pattern garbagePattern = Pattern.compile("^[+\\-*/%!=|&><\\w(),].*$");
        for (String badboi : work) {
            if (garbagePattern.matcher(badboi).find()) continue;
            throw new IllegalArgumentException("Garbage symbol \"" + badboi + "\"");
        }
        Pattern functionPattern = Pattern.compile("^(\\w\\d?)+$");
        int j = 0;
        while ((i = CemStringParser.regIndexOf(work, "^\\($", j)) >= 0) {
            j = i + 1;
            if (i <= 0 || !functionPattern.matcher(work.get(i - 1)).find()) continue;
            work.set(i + CemStringParser.takeParen(work, i).size() + 1, "}");
            work.set(i, "{");
        }
        return CemStringParser.parseLoop(work, new ArrayList<Token>());
    }

    private static Token parseLoop(ArrayList<String> input, ArrayList<Token> tokens) {
        ArrayList<String> work = new ArrayList<String>(input);
        int i = -1;
        try {
            int j;
            while ((i = CemStringParser.regIndexOf(work, "^\\{$")) >= 0) {
                int k = CemStringParser.indexOfEndOfArgs(work, i);
                tokens.add(new Token(work.get(i - 1), CemStringParser.parseArgs(work, tokens, i, k)));
                for (j = k - i + 2; j > 0; --j) {
                    work.remove(i - 1);
                }
                work.add(i - 1, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^\\($")) >= 0) {
                ArrayList<String> sub = CemStringParser.takeParen(work, i);
                if (sub.isEmpty()) {
                    throw new IllegalArgumentException("Invalid Syntax: " + (i > 0 ? work.get(i - 1) : "") + work.get(i) + (i < work.size() - 1 ? work.get(i + 1) : ""));
                }
                for (j = sub.size() + 2; j > 0; --j) {
                    work.remove(i);
                }
                tokens.add(CemStringParser.parseLoop(sub, tokens));
                work.add(i, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^(\\d+)([.]\\d+)?$")) >= 0) {
                tokens.add(new NumToken(Float.parseFloat(work.set(i, "\u00a7" + tokens.size()))));
            }
            while ((i = CemStringParser.regIndexOf(work, "^\\w(\\w\\d?:?)+([.]\\w+)?$")) >= 0) {
                tokens.add(new Token(work.set(i, "\u00a7" + tokens.size())));
            }
            i = 0;
            while (true) {
                if (!((i = CemStringParser.regIndexOf(work, "^[-+]$", i)) < 0 || i != 0 && work.get(i - 1).startsWith("\u00a7"))) {
                    if (work.get(i).equals("-")) {
                        tokens.add(new NumToken(0.0f));
                        work.add(i, "\u00a7" + (tokens.size() - 1));
                        ArrayList<Token> args = new ArrayList<Token>();
                        args.add(CemStringParser.getToken(work.get(++i - 1), tokens));
                        args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                        tokens.add(new Token("SUB", args));
                        work.remove(i);
                        work.remove(i);
                        work.set(i - 1, "\u00a7" + (tokens.size() - 1));
                        continue;
                    }
                    work.remove(i);
                    continue;
                }
                if (i == -1) break;
                ++i;
            }
            while ((i = CemStringParser.regIndexOf(work, "^[*/%]$")) >= 0) {
                ArrayList<Token> args = new ArrayList<Token>();
                args.add(CemStringParser.getToken(work.get(i - 1), tokens));
                args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                String name = switch (work.get(i)) {
                    case "*" -> "MULT";
                    case "/" -> "DIV";
                    case "%" -> "MOD";
                    default -> throw new IllegalStateException("Unexpected value: " + work.get(i));
                };
                tokens.add(new Token(name, args));
                work.remove(i);
                work.remove(i);
                work.set(i - 1, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^[+-]$")) >= 0) {
                ArrayList<Token> args = new ArrayList<Token>();
                args.add(CemStringParser.getToken(work.get(i - 1), tokens));
                args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                tokens.add(new Token(work.get(i).equals("+") ? "ADD" : "SUB", args));
                work.remove(i);
                work.remove(i);
                work.set(i - 1, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^!$")) >= 0) {
                ArrayList<Token> args = new ArrayList<Token>();
                args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                work.remove(i + 1);
                tokens.add(new Token("NOT", args));
                work.set(i, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^==|!=|<=|>=|<|>$")) >= 0) {
                ArrayList<Token> args = new ArrayList<Token>();
                args.add(CemStringParser.getToken(work.get(i - 1), tokens));
                args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                String name = switch (work.get(i)) {
                    case "==" -> "EQ";
                    case "!=" -> "NOTEQ";
                    case "<=" -> "LESSEQ";
                    case ">=" -> "GREATEREQ";
                    case "<" -> "LESS";
                    case ">" -> "GREATER";
                    default -> throw new IllegalStateException("Unexpected value: " + work.get(i));
                };
                tokens.add(new Token(name, args));
                work.remove(i);
                work.remove(i);
                work.set(i - 1, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^&&|\\|\\|$")) >= 0) {
                ArrayList<Token> args = new ArrayList<Token>();
                args.add(CemStringParser.getToken(work.get(i - 1), tokens));
                args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                tokens.add(new Token(work.get(i).equals("&&") ? "AND" : "OR", args));
                work.remove(i);
                work.remove(i);
                work.set(i - 1, "\u00a7" + (tokens.size() - 1));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\"" + e + "\" occurred when trying to parse animation at index " + i + "!");
        }
        if (work.size() != 1) {
            for (String badboi : work) {
                if (badboi.charAt(0) == '\u00a7') continue;
                throw new IllegalArgumentException("Unknown symbol \"" + badboi + "\"");
            }
            throw new IllegalArgumentException("Error parsing " + work);
        }
        return CemStringParser.getToken(work.get(0), tokens);
    }

    private static ArrayList<String> takeParen(ArrayList<String> strings, int start) {
        int lvl = 0;
        if (!strings.get(start).equals("(")) {
            throw new IllegalArgumentException("Expecting \"(\", received \"" + strings.get(start) + "\"");
        }
        for (int w = start; w < strings.size(); ++w) {
            if (strings.get(w).equals("(")) {
                ++lvl;
            }
            if (!strings.get(w).equals(")") || --lvl != 0) continue;
            return new ArrayList<String>(strings.subList(start + 1, w));
        }
        throw new NullPointerException("expected \")\"");
    }

    private static int indexOfEndOfArgs(ArrayList<String> strings, int start) {
        int lvl = 0;
        if (!strings.get(start).equals("{")) {
            throw new IllegalArgumentException("Expecting \"{\", received \"" + strings.get(start) + "\"");
        }
        for (int w = start; w < strings.size(); ++w) {
            if (strings.get(w).equals("{")) {
                ++lvl;
            }
            if (!strings.get(w).equals("}") || --lvl != 0) continue;
            return w;
        }
        throw new NullPointerException("expected \"}\"");
    }

    private static ArrayList<Token> parseArgs(ArrayList<String> strings, ArrayList<Token> tokens, int start, int end) {
        int count = 0;
        int lvl = 0;
        ArrayList args = new ArrayList();
        ArrayList<Token> tokenArgs = new ArrayList<Token>();
        for (int w = start + 1; w < end; ++w) {
            if (strings.get(w).equals(",") && lvl == 0) {
                ++count;
                continue;
            }
            if (strings.get(w).equals("{")) {
                ++lvl;
            }
            if (strings.get(w).equals("}")) {
                --lvl;
            }
            if (args.size() == count) {
                args.add(new ArrayList());
            }
            ((ArrayList)args.get(count)).add(strings.get(w));
        }
        for (ArrayList arrayList : args) {
            tokenArgs.add(CemStringParser.parseLoop(arrayList, tokens));
        }
        return tokenArgs;
    }

    private static int regIndexOf(ArrayList<String> input, String regex, int start) {
        Pattern pattern = Pattern.compile(regex);
        return CemStringParser.regIndexOf(input, pattern, start);
    }

    private static int regIndexOf(ArrayList<String> input, Pattern pattern, int start) {
        for (int i = start; i < input.size(); ++i) {
            if (!pattern.matcher(input.get(i)).find()) continue;
            return i;
        }
        return -1;
    }

    private static int regIndexOf(ArrayList<String> input, String regex) {
        return CemStringParser.regIndexOf(input, regex, 0);
    }

    private static Token getToken(String expression, ArrayList<Token> temp) {
        if (expression.charAt(0) == '\u00a7') {
            return temp.get(Integer.parseInt(expression.substring(1)));
        }
        throw new IllegalArgumentException("Invalid token reference " + expression);
    }

    private static /* synthetic */ CemStringParser[] $values() {
        return new CemStringParser[0];
    }

    static {
        $VALUES = CemStringParser.$values();
        ensure_whitespace_between_operators = Pattern.compile("\\s*(\\+|-|\\*|/|%|!=|\\|\\||&&|>=|<=|==|>|<)\\s*");
        keep_exclamation_point_with_expression = Pattern.compile("!\\s*(\\w)");
        ensure_paran_whitespace = Pattern.compile("\\s*([(),])\\s*");
        merge_whitespace = Pattern.compile("(\\s)+");
        remove_sectionsign = Pattern.compile("\u00a7");
    }
}

