/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.util;

import java.util.HashMap;
import net.dorianpb.cem.internal.file.JemFile;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.dorianpb.cem.mixins.EntityModelLayersAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5601;

public final class CemRegistryManager
extends Enum<CemRegistryManager> {
    private static final HashMap<class_5601, CemModelRegistry> EntityTypeRegistries;
    private static final HashMap<class_2591<? extends class_2586>, CemModelRegistry> BlockEntityTypeRegistries;
    private static final HashMap<String, CemModelRegistry> OtherRegistries;
    private static final /* synthetic */ CemRegistryManager[] $VALUES;

    public static CemRegistryManager[] values() {
        return (CemRegistryManager[])$VALUES.clone();
    }

    public static CemRegistryManager valueOf(String name) {
        return Enum.valueOf(CemRegistryManager.class, name);
    }

    public static void addRegistry(class_5601 entityModelLayer, JemFile file) {
        if (file != null) {
            EntityTypeRegistries.put(entityModelLayer, new CemModelRegistry(file));
        }
    }

    public static void addRegistry(class_2591<? extends class_2586> entityType, JemFile file) {
        if (file != null) {
            BlockEntityTypeRegistries.put(entityType, new CemModelRegistry(file));
        }
    }

    public static void addRegistry(String entityType, JemFile file) {
        if (file != null) {
            OtherRegistries.put(entityType, new CemModelRegistry(file));
        }
    }

    public static boolean hasEntity(class_1299<? extends class_1297> entityType) {
        return EntityTypeRegistries.containsKey(new class_5601(class_1299.method_5890(entityType), EntityModelLayersAccessor.getMAIN()));
    }

    public static boolean hasEntityLayer(class_5601 entityModelLayer) {
        return EntityTypeRegistries.containsKey(entityModelLayer);
    }

    public static boolean hasEntity(class_2591<? extends class_2586> entityType) {
        return BlockEntityTypeRegistries.containsKey(entityType);
    }

    public static boolean hasEntity(String entityType) {
        return OtherRegistries.containsKey(entityType);
    }

    public static CemModelRegistry getRegistry(class_5601 entityModelLayer) {
        return EntityTypeRegistries.get(entityModelLayer);
    }

    public static CemModelRegistry getRegistry(class_1299<? extends class_1297> entityType) {
        return EntityTypeRegistries.get(new class_5601(class_1299.method_5890(entityType), EntityModelLayersAccessor.getMAIN()));
    }

    public static CemModelRegistry getRegistry(class_2591<? extends class_2586> entityType) {
        return BlockEntityTypeRegistries.get(entityType);
    }

    public static CemModelRegistry getRegistry(String entityType) {
        return OtherRegistries.get(entityType);
    }

    public static void clearRegistries() {
        EntityTypeRegistries.clear();
        BlockEntityTypeRegistries.clear();
        OtherRegistries.clear();
    }

    private static /* synthetic */ CemRegistryManager[] $values() {
        return new CemRegistryManager[0];
    }

    static {
        $VALUES = CemRegistryManager.$values();
        EntityTypeRegistries = new HashMap();
        BlockEntityTypeRegistries = new HashMap();
        OtherRegistries = new HashMap();
    }
}

