/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.models;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dorianpb.cem.internal.config.CemConfigFairy;
import net.dorianpb.cem.internal.file.JemFile;
import net.dorianpb.cem.internal.file.JemModel;
import net.dorianpb.cem.internal.models.CemAnimation;
import net.dorianpb.cem.internal.models.CemBoolVarAnimation;
import net.dorianpb.cem.internal.models.CemFloatVarAnimation;
import net.dorianpb.cem.internal.models.CemModelAnimation;
import net.dorianpb.cem.internal.models.CemModelEntry;
import net.dorianpb.cem.internal.models.CemModelPart;
import net.dorianpb.cem.internal.models.TransparentCemModelPart;
import net.dorianpb.cem.internal.util.CemFairy;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public final class CemModelRegistry {
    private final HashMap<ArrayList<String>, CemModelEntry> database = new HashMap();
    private final List<CemAnimation> animations = new ArrayList<CemAnimation>();
    private final HashMap<String, CemModelEntry> partNameRefs;
    private final JemFile file;
    private final Map<String, Boolean> boolanimvars = new HashMap<String, Boolean>();
    private final Map<String, Float> floatanimvars = new HashMap<String, Float>();

    public CemModelRegistry(JemFile file) {
        JemModel data;
        this.partNameRefs = new HashMap();
        this.file = file;
        for (String part : this.file.getModelList()) {
            data = this.file.getModel(part);
            this.addEntry(new CemModelEntry(data, file.getTextureSize().get(0).intValue(), file.getTextureSize().get(1).intValue()), new ArrayList<String>());
        }
        for (String part : this.file.getModelList()) {
            data = this.file.getModel(part);
            for (String key : data.getAnimations().keySet()) {
                try {
                    if (key.startsWith("var.")) {
                        this.animations.add(new CemFloatVarAnimation(key.substring("var.".length()), data.getAnimations().get(key), this));
                        continue;
                    }
                    if (key.startsWith("varb.")) {
                        this.animations.add(new CemBoolVarAnimation(key.substring("varb.".length()), data.getAnimations().get(key), this));
                        continue;
                    }
                    this.animations.add(new CemModelAnimation(this.findChild(key.substring(0, key.indexOf(46)), this.findChild(part)), data.getAnimations().get(key), key.substring(key.indexOf(46) + 1), this));
                }
                catch (Exception e) {
                    CemFairy.getLogger().error("Error applying animation \"" + data.getAnimations().get(key) + "\" in \"" + file.getPath() + "\":");
                    CemFairy.getLogger().error(e.getMessage());
                }
            }
        }
    }

    private static void prepChild(CemModelPart parent, CemModelPart child) {
        if (parent == null || child == null) {
            return;
        }
        child.field_3657 -= parent.field_3657;
        child.field_3656 -= parent.field_3656;
        child.field_3655 -= parent.field_3655;
    }

    Map<String, Boolean> getBoolanimvars() {
        return this.boolanimvars;
    }

    Map<String, Float> getFloatanimvars() {
        return this.floatanimvars;
    }

    public CemModelPart prepRootPart(class_630 vanillaPart, @Nullable BiMap<String, String> partNames, @Nullable Map<String, class_5603> modelFixes, @Nullable Object identifier) {
        CemModelPart newRoot = new CemModelPart();
        this.constructPart(newRoot, vanillaPart, partNames, modelFixes, identifier);
        newRoot.setIdentifier(identifier);
        return newRoot;
    }

    private void constructPart(CemModelPart cemparent, class_630 vanillapart, @Nullable BiMap<String, String> partNames, @Nullable Map<String, class_5603> modelFixes, Object identifier) {
        for (String partname : vanillapart.field_3661.keySet()) {
            CemModelPart transpart = null;
            CemModelPart part = partNames != null && this.partNameRefs.containsKey(partNames.inverse().getOrDefault((Object)partname, (Object)partname)) ? this.partNameRefs.get(partNames.inverse().getOrDefault((Object)partname, (Object)partname)).getModel() : (this.partNameRefs.containsKey(partname) ? this.partNameRefs.get(partname).getModel() : new CemModelPart());
            this.constructPart(part, vanillapart.method_32086(partname), partNames, modelFixes, identifier);
            CemModelRegistry.prepChild(cemparent, part);
            part.setIdentifier(identifier);
            if (CemConfigFairy.getConfig().useTransparentParts()) {
                class_5603 transform = modelFixes != null && modelFixes.containsKey(partname) ? class_5603.method_32091((float)modelFixes.get((Object)partname).field_27702, (float)modelFixes.get((Object)partname).field_27703, (float)modelFixes.get((Object)partname).field_27704, (float)part.field_3654, (float)part.field_3675, (float)part.field_3674) : part.method_32084();
                transpart = new TransparentCemModelPart(part, transform, vanillapart.method_32086(partname).method_32084());
            }
            cemparent.addChild(partname, CemConfigFairy.getConfig().useTransparentParts() ? transpart : part);
        }
    }

    private void addEntry(CemModelEntry entry, ArrayList<String> parentRefmap) {
        ArrayList<Object> refmap;
        if (parentRefmap != null && !parentRefmap.isEmpty()) {
            refmap = new ArrayList<String>(parentRefmap);
        } else {
            refmap = new ArrayList();
            if (entry.getPart() != null) {
                this.partNameRefs.put(entry.getPart(), entry);
            }
        }
        refmap.add(entry.getId() == null ? entry.getPart() : entry.getId());
        this.database.put(refmap, entry);
        for (CemModelEntry child : entry.getChildren().values()) {
            this.addEntry(child, refmap);
        }
    }

    public boolean hasTexture() {
        return this.file.getTexture() != null;
    }

    public class_2960 getTexture() {
        if (this.file.getTexture() == null) {
            throw new NullPointerException("Trying to retrieve a null texture");
        }
        return this.file.getTexture();
    }

    public boolean hasShadowRadius() {
        return this.file.getShadowsize() != null;
    }

    public float getShadowRadius() {
        return this.file.getShadowsize().floatValue();
    }

    public void applyAnimations(float limbAngle, float limbDistance, float age, float head_yaw, float head_pitch, class_1297 entity) {
        for (CemAnimation anim : this.animations) {
            anim.apply(limbAngle, limbDistance, age, head_yaw, head_pitch, entity);
        }
    }

    public CemModelEntry findChild(String target, CemModelEntry parent) {
        CemModelEntry victim = null;
        ArrayList<String> hit = null;
        ArrayList<String> refmap = new ArrayList<String>(Arrays.asList(target.split(":")));
        if (refmap.size() == 1 && this.partNameRefs.containsKey(refmap.get(0))) {
            victim = this.partNameRefs.get(refmap.get(0));
            return victim;
        }
        if (parent != null && (refmap.get(0).equals("this") || refmap.get(0).equals("part"))) {
            if (refmap.size() == 1) {
                return parent;
            }
            StringBuilder newTarget = new StringBuilder(25);
            newTarget.append(parent.getId() == null ? parent.getPart() : parent.getId());
            for (int i = 1; i < refmap.size(); ++i) {
                newTarget.append(":").append(refmap.get(i));
            }
            return this.findChild(newTarget.toString(), parent);
        }
        for (ArrayList<String> part : this.database.keySet()) {
            ArrayList<Integer> search = new ArrayList<Integer>();
            for (String ref : refmap) {
                search.add(part.indexOf(ref));
            }
            boolean hi = search.size() != 1 || (Integer)search.get(0) > -1;
            for (int i = 0; i < search.size() - 1; ++i) {
                hi = hi && (Integer)search.get(i) < (Integer)search.get(i + 1) && (Integer)search.get(i) > -1;
            }
            if (hi && (hit == null || part.size() < hit.size())) {
                hit = part;
            }
            victim = this.database.get(hit);
        }
        if (victim == null) {
            throw new NullPointerException("Model part " + target + " isn't specified in " + this.file.getPath());
        }
        return victim;
    }

    private CemModelEntry findChild(String target) {
        return this.findChild(target, null);
    }
}

