/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public class CemModelPart
extends class_630 {
    private final float[] scale;
    private final float[] rotation;
    private final int textureWidth;
    private final int textureHeight;
    private CemModelPart parent;
    private Object identifier;

    CemModelPart() {
        this(0, 0, new ArrayList<class_630.class_628>());
    }

    CemModelPart(int textureWidth, int textureHeight, List<class_630.class_628> cuboids) {
        super(cuboids, new HashMap());
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.scale = new float[]{1.0f, 1.0f, 1.0f};
        this.rotation = new float[]{0.0f, 0.0f, 0.0f};
    }

    CemModelPart(int textureWidth, int textureHeight) {
        this(textureWidth, textureHeight, new ArrayList<class_630.class_628>());
    }

    public static CemModelPart of(class_630 modelPart) {
        CemModelPart newPart = modelPart instanceof CemModelPart ? new CemModelPart(((CemModelPart)modelPart).textureWidth, ((CemModelPart)modelPart).textureHeight) : new CemModelPart();
        for (Map.Entry entry : modelPart.field_3661.entrySet()) {
            newPart.field_3661.put((String)entry.getKey(), CemModelPart.of((class_630)entry.getValue()));
        }
        newPart.field_3663.addAll(modelPart.field_3663);
        newPart.method_17138(modelPart);
        newPart.field_3665 = modelPart.field_3665;
        return newPart;
    }

    void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scale[0] = scaleX;
        this.scale[1] = scaleY;
        this.scale[2] = scaleZ;
    }

    void setRotation(float rotX, float rotY, float rotZ) {
        this.rotation[0] = rotX;
        this.rotation[1] = rotY;
        this.rotation[2] = rotZ;
    }

    void setScale(char axis, float scale) {
        switch (axis) {
            case 'x': {
                this.scale[0] = scale;
                break;
            }
            case 'y': {
                this.scale[1] = scale;
                break;
            }
            case 'z': {
                this.scale[2] = scale;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown axis \"" + axis + "\"");
            }
        }
    }

    public void setRotation(char axis, float rot) {
        switch (axis) {
            case 'x': {
                this.rotation[0] = rot;
                this.field_3654 = 0.0f;
                break;
            }
            case 'y': {
                this.rotation[1] = rot;
                this.field_3675 = 0.0f;
                break;
            }
            case 'z': {
                this.rotation[2] = rot;
                this.field_3674 = 0.0f;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown axis \"" + axis + "\"");
            }
        }
    }

    public float getScale(char axis) {
        return switch (axis) {
            case 'x' -> this.scale[0];
            case 'y' -> this.scale[1];
            case 'z' -> this.scale[2];
            default -> throw new IllegalStateException("Unknown axis \"" + axis + "\"");
        };
    }

    public float getRotation(char axis) {
        switch (axis) {
            case 'x': {
                float angle = this.field_3654;
                if (this.parent != null) {
                    angle += this.parent.field_3654;
                }
                return angle + this.rotation[0];
            }
            case 'y': {
                float angle = this.field_3675;
                if (this.parent != null) {
                    angle += this.parent.field_3675;
                }
                return angle + this.rotation[1];
            }
            case 'z': {
                float angle = this.field_3674;
                if (this.parent != null) {
                    angle += this.parent.field_3674;
                }
                return angle + this.rotation[2];
            }
        }
        throw new IllegalStateException("Unknown axis \"" + axis + "\"");
    }

    void addChild(String name, class_630 modelPart) {
        this.field_3661.put(name, modelPart);
    }

    void inflate(float scale) {
        throw new RuntimeException("i should probably fix this at some point");
    }

    CemModelPart getParent() {
        return this.parent;
    }

    void setParent(CemModelPart modelPart) {
        this.parent = modelPart;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    void setIdentifier(Object obj) {
        this.identifier = obj;
    }

    public void method_17138(class_630 part) {
        super.method_17138(part);
        if (part instanceof CemModelPart) {
            for (int i = 0; i < 3; ++i) {
                this.rotation[i] = ((CemModelPart)part).rotation[i];
                this.scale[i] = ((CemModelPart)part).scale[i];
            }
            if (this.field_3661.keySet().equals(part.field_3661.keySet())) {
                for (Map.Entry entry : part.field_3661.entrySet()) {
                    ((class_630)this.field_3661.get(entry.getKey())).method_17138((class_630)entry.getValue());
                }
            }
        }
    }

    public class_630 method_32086(String name) {
        class_630 child = (class_630)this.field_3661.get(name);
        if (child == null) {
            this.field_3661.put(name, new CemModelPart());
            return this.method_32086(name);
        }
        return super.method_32086(name);
    }

    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        matrices.method_22905(this.scale[0], this.scale[1], this.scale[2]);
        super.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    public void method_22703(class_4587 matrix) {
        this.field_3654 += this.rotation[0];
        this.field_3675 += this.rotation[1];
        this.field_3674 += this.rotation[2];
        super.method_22703(matrix);
        this.field_3654 -= this.rotation[0];
        this.field_3675 -= this.rotation[1];
        this.field_3674 -= this.rotation[2];
    }
}

