/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.models;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dorianpb.cem.internal.config.CemConfigFairy;
import net.dorianpb.cem.internal.file.JemModel;
import net.dorianpb.cem.internal.file.JpmBox;
import net.dorianpb.cem.internal.file.JpmFile;
import net.dorianpb.cem.internal.models.CemCuboid;
import net.dorianpb.cem.internal.models.CemModelPart;
import net.minecraft.class_630;

public class CemModelEntry {
    private final String id;
    private final String part;
    private final Map<String, CemModelEntry> children;
    private final CemModelPart model;
    private final float[] translates;
    private final float[] rotates;
    private final boolean[] invertAxis;
    private final int gen;
    private final float[] offsets;

    CemModelEntry(JemModel file, int textureWidth, int textureHeight) {
        this(file.getPart(), file.getModelDef(), new float[]{0.0f, 24.0f, 0.0f}, 0, file.getScale().floatValue(), textureWidth, textureHeight);
        if (!file.getAnimations().isEmpty()) {
            for (String key : file.getAnimations().keySet()) {
                if (key.contains(".")) continue;
                throw new InvalidParameterException("Invalid Syntax: " + key);
            }
        }
    }

    private CemModelEntry(String part, JpmFile data, float[] parents, int gen, float scale, int textureWidth, int textureHeight) {
        this.id = data.getId();
        this.part = part;
        this.children = new HashMap<String, CemModelEntry>();
        this.invertAxis = data.getInvertAxis();
        this.gen = gen;
        this.translates = new float[]{data.getTranslate().get(0).floatValue() * (float)(this.invertAxis[0] ? -1 : 1), data.getTranslate().get(1).floatValue() * (float)(this.invertAxis[1] ? -1 : 1), data.getTranslate().get(2).floatValue() * (float)(this.invertAxis[2] ? -1 : 1)};
        this.rotates = new float[]{data.getRotate().get(0).floatValue() * (float)(this.invertAxis[0] ? 1 : -1), data.getRotate().get(1).floatValue() * (float)(this.invertAxis[1] ? 1 : -1), data.getRotate().get(2).floatValue() * (float)(this.invertAxis[2] ? 1 : -1)};
        this.model = new CemModelPart(textureWidth, textureHeight, this.makecuboids(data, textureWidth, textureHeight));
        this.initmodel(data, parents, scale);
        this.offsets = new float[]{0.0f, 0.0f, 0.0f};
        if (data.getSubmodels() != null) {
            for (JpmFile submodel : data.getSubmodels()) {
                float childY;
                float childZ;
                float f = this.gen == 0 ? data.getTranslate().get(2).floatValue() * (float)(this.invertAxis[2] ? -1 : 1) : (childZ = 0.0f);
                float f2 = this.gen == 0 ? data.getTranslate().get(1).floatValue() * (float)(this.invertAxis[1] ? -1 : 1) : (childY = 0.0f);
                float childX = this.gen == 0 ? data.getTranslate().get(0).floatValue() * (float)(this.invertAxis[0] ? -1 : 1) : 0.0f;
                this.addChild(new CemModelEntry(null, submodel, new float[]{childX, childY, childZ}, this.gen + 1, 1.0f, textureWidth, textureHeight));
            }
        }
    }

    private List<class_630.class_628> makecuboids(JpmFile data, int textureWidth, int textureHeight) {
        ArrayList<class_630.class_628> cuboids = new ArrayList<class_630.class_628>(data.getBoxes() != null ? data.getBoxes().size() : 0);
        float[] translate = new float[]{data.getTranslate().get(0).floatValue(), data.getTranslate().get(1).floatValue(), data.getTranslate().get(2).floatValue()};
        if (data.getBoxes() != null) {
            for (JpmBox box : data.getBoxes()) {
                float extra;
                if (box.useUvMap()) {
                    extra = box.getSizeAdd().floatValue();
                    cuboids.add(new CemCuboid((box.getCoordinates().get(0).floatValue() + (this.gen == 0 ? translate[0] : 0.0f)) * (float)(this.invertAxis[0] ? -1 : 1) - (this.invertAxis[0] ? box.getCoordinates().get(3).floatValue() : 0.0f), (box.getCoordinates().get(1).floatValue() + (this.gen == 0 ? translate[1] : 0.0f)) * (float)(this.invertAxis[1] ? -1 : 1) - (this.invertAxis[1] ? box.getCoordinates().get(4).floatValue() : 0.0f), (box.getCoordinates().get(2).floatValue() + (this.gen == 0 ? translate[2] : 0.0f)) * (float)(this.invertAxis[2] ? -1 : 1) - (this.invertAxis[2] ? box.getCoordinates().get(5).floatValue() : 0.0f), box.getCoordinates().get(3).intValue(), box.getCoordinates().get(4).intValue(), box.getCoordinates().get(5).intValue(), extra, extra, extra, data.getMirrorTexture()[0], data.getMirrorTexture()[1], textureWidth, textureHeight, box.getUv("north"), box.getUv("south"), box.getUv("east"), box.getUv("west"), box.getUv("up"), box.getUv("down")));
                    continue;
                }
                extra = box.getSizeAdd().floatValue();
                cuboids.add(new CemCuboid((box.getCoordinates().get(0).floatValue() + (this.gen == 0 ? translate[0] : 0.0f)) * (float)(this.invertAxis[0] ? -1 : 1) - (this.invertAxis[0] ? box.getCoordinates().get(3).floatValue() : 0.0f), (box.getCoordinates().get(1).floatValue() + (this.gen == 0 ? translate[1] : 0.0f)) * (float)(this.invertAxis[1] ? -1 : 1) - (this.invertAxis[1] ? box.getCoordinates().get(4).floatValue() : 0.0f), (box.getCoordinates().get(2).floatValue() + (this.gen == 0 ? translate[2] : 0.0f)) * (float)(this.invertAxis[2] ? -1 : 1) - (this.invertAxis[2] ? box.getCoordinates().get(5).floatValue() : 0.0f), box.getCoordinates().get(3).intValue(), box.getCoordinates().get(4).intValue(), box.getCoordinates().get(5).intValue(), extra, extra, extra, data.getMirrorTexture()[0], data.getMirrorTexture()[1], textureWidth, textureHeight, box.getTextureOffset().get(0).intValue(), box.getTextureOffset().get(1).intValue()));
            }
        }
        return cuboids;
    }

    private void initmodel(JpmFile data, float[] parents, float scale) {
        float[] fArray = new float[3];
        float f = this.gen == 0 ? parents[0] - data.getTranslate().get(0).floatValue() * (float)(this.invertAxis[0] ? -1 : 1) : (this.gen == 1 ? parents[0] + data.getTranslate().get(0).floatValue() * (float)(this.invertAxis[0] ? -1 : 1) : (fArray[0] = data.getTranslate().get(0).floatValue() * (float)(this.invertAxis[1] ? -1 : 1)));
        float f2 = this.gen == 0 ? parents[1] - data.getTranslate().get(1).floatValue() * (float)(this.invertAxis[1] ? -1 : 1) : (this.gen == 1 ? parents[1] + data.getTranslate().get(1).floatValue() * (float)(this.invertAxis[1] ? -1 : 1) : (fArray[1] = data.getTranslate().get(1).floatValue() * (float)(this.invertAxis[1] ? -1 : 1)));
        fArray[2] = this.gen == 0 ? parents[2] - data.getTranslate().get(2).floatValue() * (float)(this.invertAxis[2] ? -1 : 1) : (this.gen == 1 ? parents[2] + data.getTranslate().get(2).floatValue() * (float)(this.invertAxis[2] ? -1 : 1) : data.getTranslate().get(2).floatValue() * (float)(this.invertAxis[2] ? -1 : 1));
        float[] pivot = fArray;
        this.model.method_2851(pivot[0], pivot[1], pivot[2]);
        this.model.setRotation(this.rotates[0], this.rotates[1], this.rotates[2]);
        this.model.setScale(scale, scale, scale);
    }

    private void addChild(CemModelEntry child) {
        if (this.children.containsKey(child.id)) {
            throw new InvalidParameterException("Child " + child.id + " already exists for parent " + this.id);
        }
        this.children.put(child.id, child);
        this.model.addChild(child.id, child.model);
    }

    String getId() {
        return this.id;
    }

    public CemModelPart getModel() {
        return this.model;
    }

    String getPart() {
        return this.part;
    }

    void setTranslate(char axis, float requestedTranslate) {
        if (CemConfigFairy.getConfig().useOldAnimations()) {
            switch (axis) {
                case 'x': {
                    float oldTranslate = this.translates[0];
                    this.translates[0] = requestedTranslate;
                    this.model.field_3657 += this.translates[0] - oldTranslate;
                    break;
                }
                case 'y': {
                    float oldTranslate = this.translates[1];
                    this.translates[1] = requestedTranslate;
                    this.model.field_3656 += this.translates[1] - oldTranslate;
                    break;
                }
                case 'z': {
                    float oldTranslate = this.translates[2];
                    this.translates[2] = requestedTranslate;
                    this.model.field_3655 += this.translates[2] - oldTranslate;
                }
            }
        } else {
            float currentTranslate = this.getTranslate(axis);
            switch (axis) {
                case 'x': {
                    this.model.field_3657 += requestedTranslate - currentTranslate;
                    this.offsets[0] = this.offsets[0] + (requestedTranslate - currentTranslate);
                    break;
                }
                case 'y': {
                    this.model.field_3656 += requestedTranslate - currentTranslate;
                    this.offsets[1] = this.offsets[1] + (requestedTranslate - currentTranslate);
                    break;
                }
                case 'z': {
                    this.model.field_3655 += requestedTranslate - currentTranslate;
                    this.offsets[2] = this.offsets[2] + (requestedTranslate - currentTranslate);
                }
            }
        }
    }

    public float getTranslate(char axis) {
        if (CemConfigFairy.getConfig().useOldAnimations()) {
            return switch (axis) {
                case 'x' -> this.translates[0];
                case 'y' -> this.translates[1];
                case 'z' -> this.translates[2];
                default -> throw new IllegalStateException("Unknown axis \"" + axis + "\"");
            };
        }
        switch (axis) {
            case 'x': {
                float value;
                float f = value = this.gen != 0 ? this.translates[0] + this.offsets[0] : this.model.field_3657;
                if (this.model.getParent() != null) {
                    value += this.model.getParent().field_3657;
                }
                return value;
            }
            case 'y': {
                float value;
                float f = value = this.gen != 0 ? this.translates[1] + this.offsets[1] : this.model.field_3656;
                if (this.model.getParent() != null) {
                    value += this.model.getParent().field_3656;
                }
                return value;
            }
            case 'z': {
                float value;
                float f = value = this.gen != 0 ? this.translates[2] + this.offsets[2] : this.model.field_3655;
                if (this.model.getParent() != null) {
                    value += this.model.getParent().field_3655;
                }
                return value;
            }
        }
        throw new IllegalStateException("Unknown axis \"" + axis + "\"");
    }

    void setRotate(char axis, float requestedAngle) {
        if (CemConfigFairy.getConfig().useOldAnimations()) {
            this.model.setRotation(axis, requestedAngle);
        } else {
            float angle = requestedAngle;
            if (this.model.getParent() != null) {
                angle -= this.model.getParent().getRotation(axis);
            }
            this.model.setRotation(axis, angle);
        }
    }

    Map<String, CemModelEntry> getChildren() {
        return this.children;
    }
}

