/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.models;

import java.lang.invoke.WrongMethodTypeException;
import java.util.Map;
import net.dorianpb.cem.internal.models.CemAnimation;
import net.dorianpb.cem.internal.models.CemModelEntry;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.dorianpb.cem.internal.util.stringparser.CemStringParser;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpression;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpressionFloat;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunctionType;
import net.minecraft.class_1297;

class CemModelAnimation
implements CemAnimation {
    private final CemModelEntry target;
    private final ParsedExpressionFloat expression;
    private final char operation;
    private final char axis;
    private final Map<String, Boolean> boolanimvars;
    private final Map<String, Float> floatanimvars;

    CemModelAnimation(CemModelEntry target, String expr, String var, CemModelRegistry registry) {
        this.target = target;
        this.floatanimvars = registry.getFloatanimvars();
        this.boolanimvars = registry.getBoolanimvars();
        ParsedExpression parsedExpression = CemStringParser.parse(expr, registry, this.target);
        if (parsedExpression.getType() != ParsedFunctionType.FLOAT) {
            throw new WrongMethodTypeException("\"" + parsedExpression.getName() + " must evaluate to a number, not a boolean!");
        }
        this.expression = (ParsedExpressionFloat)parsedExpression;
        this.operation = var.charAt(0);
        this.axis = var.charAt(1);
    }

    @Override
    public void apply(float limbAngle, float limbDistance, float age, float head_yaw, float head_pitch, class_1297 entity) {
        float val = this.expression.eval(limbAngle, limbDistance, age, head_yaw, head_pitch, entity, this.boolanimvars, this.floatanimvars);
        if (Float.isNaN(val)) {
            this.target.getModel().field_3665 = false;
        } else {
            this.target.getModel().field_3665 = true;
            switch (this.operation) {
                case 't': {
                    this.target.setTranslate(this.axis, val);
                    break;
                }
                case 'r': {
                    this.target.setRotate(this.axis, val);
                    break;
                }
                case 's': {
                    this.target.getModel().setScale(this.axis, val);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation \"" + this.operation + "\"");
                }
            }
        }
    }
}

