/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.models;

import java.lang.invoke.WrongMethodTypeException;
import java.util.Map;
import net.dorianpb.cem.internal.models.CemAnimation;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.dorianpb.cem.internal.util.stringparser.CemStringParser;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpression;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpressionFloat;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunctionType;
import net.minecraft.class_1297;

class CemFloatVarAnimation
implements CemAnimation {
    private final String target;
    private final ParsedExpressionFloat expression;
    private final Map<String, Boolean> boolanimvars;
    private final Map<String, Float> floatanimvars;

    CemFloatVarAnimation(String target, String expr, CemModelRegistry registry) {
        this.target = target;
        ParsedExpression parsedExpression = CemStringParser.parse(expr, registry, null);
        if (parsedExpression.getType() != ParsedFunctionType.FLOAT) {
            throw new WrongMethodTypeException("\"" + parsedExpression.getName() + " must evaluate to a number, not a boolean!");
        }
        this.expression = (ParsedExpressionFloat)parsedExpression;
        this.boolanimvars = registry.getBoolanimvars();
        this.floatanimvars = registry.getFloatanimvars();
    }

    @Override
    public void apply(float limbAngle, float limbDistance, float age, float head_yaw, float head_pitch, class_1297 entity) {
        float val = this.expression.eval(limbAngle, limbDistance, age, head_yaw, head_pitch, entity, this.boolanimvars, this.floatanimvars);
        this.floatanimvars.put(this.target, Float.valueOf(val));
    }
}

