/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.models;

import java.lang.invoke.WrongMethodTypeException;
import java.util.Map;
import net.dorianpb.cem.internal.models.CemAnimation;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.dorianpb.cem.internal.util.stringparser.CemStringParser;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpression;
import net.dorianpb.cem.internal.util.stringparser.ParsedExpressionBool;
import net.dorianpb.cem.internal.util.stringparser.ParsedFunctionType;
import net.minecraft.class_1297;

class CemBoolVarAnimation
implements CemAnimation {
    private final String target;
    private final ParsedExpressionBool expression;
    private final Map<String, Boolean> boolanimvars;
    private final Map<String, Float> floatanimvars;

    CemBoolVarAnimation(String target, String expr, CemModelRegistry registry) {
        this.target = target;
        ParsedExpression parsedExpression = CemStringParser.parse(expr, registry, null);
        if (parsedExpression.getType() != ParsedFunctionType.BOOL) {
            throw new WrongMethodTypeException("\"" + parsedExpression.getName() + " must evaluate to a boolean, not a number!");
        }
        this.expression = (ParsedExpressionBool)parsedExpression;
        this.boolanimvars = registry.getBoolanimvars();
        this.floatanimvars = registry.getFloatanimvars();
    }

    @Override
    public void apply(float limbAngle, float limbDistance, float age, float head_yaw, float head_pitch, class_1297 entity) {
        boolean val = this.expression.eval(limbAngle, limbDistance, age, head_yaw, head_pitch, entity, this.boolanimvars, this.floatanimvars);
        this.boolanimvars.put(this.target, val);
    }
}

