/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.file;

import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.dorianpb.cem.internal.file.JpmBox;
import net.dorianpb.cem.internal.file.JpmSprite;
import net.dorianpb.cem.internal.util.CemFairy;

public class JpmFile {
    private final String id;
    private final String texture;
    private final List<Double> textureSize;
    private final boolean[] invertAxis;
    private final List<Double> translate;
    private final ArrayList<Double> rotate;
    private final Boolean[] mirrorTexture;
    private final List<JpmBox> boxes;
    private final List<JpmSprite> sprites;
    private final List<JpmFile> submodels;

    JpmFile(LinkedTreeMap json) {
        this.id = CemFairy.JSONparseString(json.get((Object)"id"));
        this.texture = CemFairy.JSONparseString(json.get((Object)"texture"));
        this.textureSize = CemFairy.JSONparseDoubleList(json.get((Object)"textureSize"));
        String axes = CemFairy.JSONparseString(json.getOrDefault((Object)"invertAxis", (Object)""));
        assert (axes != null);
        this.invertAxis = new boolean[]{axes.contains("x"), axes.contains("y"), axes.contains("z")};
        this.translate = CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"translate", new ArrayList<Double>(Arrays.asList(0.0, 0.0, 0.0))));
        this.rotate = CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"rotate", new ArrayList<Double>(Arrays.asList(0.0, 0.0, 0.0))));
        for (int i = 0; i < Objects.requireNonNull(this.rotate).size(); ++i) {
            this.rotate.set(i, -Math.toRadians(this.rotate.get(i)));
        }
        String mirror = CemFairy.JSONparseString(json.getOrDefault((Object)"mirrorTexture", (Object)""));
        assert (mirror != null);
        this.mirrorTexture = new Boolean[]{mirror.contains("u"), mirror.contains("v")};
        if (json.containsKey((Object)"boxes")) {
            this.boxes = new ArrayList<JpmBox>();
            for (LinkedTreeMap cube : (Iterable)json.get((Object)"boxes")) {
                this.boxes.add(new JpmBox(cube));
            }
        } else {
            this.boxes = null;
        }
        if (json.containsKey((Object)"sprites")) {
            this.sprites = new ArrayList<JpmSprite>();
            for (LinkedTreeMap sprite : (Iterable)json.get((Object)"sprites")) {
                this.sprites.add(new JpmSprite(sprite));
            }
        } else {
            this.sprites = null;
        }
        if (json.containsKey((Object)"submodel") || json.containsKey((Object)"submodels")) {
            this.submodels = new ArrayList<JpmFile>();
            if (json.containsKey((Object)"submodel")) {
                this.submodels.add(new JpmFile((LinkedTreeMap)json.get((Object)"submodel")));
            }
            if (json.containsKey((Object)"submodels")) {
                for (LinkedTreeMap submodel : (Iterable)json.get((Object)"submodels")) {
                    this.submodels.add(new JpmFile(submodel));
                }
            }
        } else {
            this.submodels = null;
        }
    }

    public List<JpmBox> getBoxes() {
        return this.boxes;
    }

    public List<Double> getTranslate() {
        return this.translate;
    }

    public boolean[] getInvertAxis() {
        return this.invertAxis;
    }

    public Iterable<JpmFile> getSubmodels() {
        return this.submodels;
    }

    public List<Double> getRotate() {
        return this.rotate;
    }

    public String getId() {
        return this.id;
    }

    public Boolean[] getMirrorTexture() {
        return this.mirrorTexture;
    }
}

