/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.file;

import com.google.gson.internal.LinkedTreeMap;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dorianpb.cem.internal.util.CemFairy;
import org.jetbrains.annotations.Nullable;

public class JpmBox {
    private final List<Double> textureOffset;
    private final List<Double> uvUp;
    private final List<Double> uvDown;
    private final List<Double> uvFront;
    private final List<Double> uvBack;
    private final List<Double> uvLeft;
    private final List<Double> uvRight;
    private final List<Double> coordinates;
    private final Double sizeAdd;

    JpmBox(LinkedTreeMap json) {
        this.textureOffset = CemFairy.JSONparseDoubleList(json.get((Object)"textureOffset"));
        this.uvUp = JpmBox.getNull(CemFairy.JSONparseDoubleList(json.get((Object)"uvUp")));
        this.uvDown = JpmBox.getNull(CemFairy.JSONparseDoubleList(json.get((Object)"uvDown")));
        this.uvFront = JpmBox.getNull(CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"uvFront", json.get((Object)"uvNorth"))));
        this.uvBack = JpmBox.getNull(CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"uvBack", json.get((Object)"uvSouth"))));
        this.uvLeft = JpmBox.getNull(CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"uvLeft", json.get((Object)"uvWest"))));
        this.uvRight = JpmBox.getNull(CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"uvRight", json.get((Object)"uvEast"))));
        this.coordinates = CemFairy.JSONparseDoubleList(json.get((Object)"coordinates"));
        this.sizeAdd = (Double)json.getOrDefault((Object)"sizeAdd", (Object)0.0);
        this.validate();
    }

    private static List<Double> getNull(@Nullable List<Double> obj) {
        return obj == null ? new ArrayList() : obj;
    }

    private void validate() {
        if (this.textureOffset == null) {
            boolean triedToUseUV = false;
            for (List uvCoords : new List[]{this.uvUp, this.uvDown, this.uvFront, this.uvBack, this.uvLeft, this.uvRight}) {
                triedToUseUV = triedToUseUV || uvCoords.size() == 4;
            }
            if (triedToUseUV) {
                List<Double> doubles = Arrays.asList(0.0, 0.0, 0.0, 0.0);
                boolean warn = false;
                for (List uvCoords : new List[]{this.uvUp, this.uvDown, this.uvFront, this.uvBack, this.uvLeft, this.uvRight}) {
                    if (!uvCoords.isEmpty()) continue;
                    uvCoords.addAll(doubles);
                    warn = true;
                }
                if (warn) {
                    CemFairy.getLogger().warn("\tthe above file didn't specify all uv directions!");
                }
            } else {
                throw new InvalidParameterException("Either \"textureOffset\" or at least one of the uv directions are required!");
            }
        }
        if (this.coordinates == null) {
            throw new InvalidParameterException("Element \"coordinates\" is required");
        }
    }

    public boolean useUvMap() {
        return this.textureOffset == null;
    }

    public List<Double> getTextureOffset() {
        return this.textureOffset;
    }

    public List<Double> getCoordinates() {
        return this.coordinates;
    }

    public Double getSizeAdd() {
        return this.sizeAdd;
    }

    public float[] getUv(String direction) {
        float[] fArray;
        switch (direction.toLowerCase()) {
            case "down": {
                float[] fArray2 = new float[4];
                fArray2[0] = this.uvUp.get(0).floatValue();
                fArray2[1] = this.uvUp.get(1).floatValue();
                fArray2[2] = this.uvUp.get(2).floatValue();
                fArray = fArray2;
                fArray2[3] = this.uvUp.get(3).floatValue();
                break;
            }
            case "up": {
                float[] fArray3 = new float[4];
                fArray3[0] = this.uvDown.get(0).floatValue();
                fArray3[1] = this.uvDown.get(1).floatValue();
                fArray3[2] = this.uvDown.get(2).floatValue();
                fArray = fArray3;
                fArray3[3] = this.uvDown.get(3).floatValue();
                break;
            }
            case "front": 
            case "north": {
                float[] fArray4 = new float[4];
                fArray4[0] = this.uvFront.get(0).floatValue();
                fArray4[1] = this.uvFront.get(1).floatValue();
                fArray4[2] = this.uvFront.get(2).floatValue();
                fArray = fArray4;
                fArray4[3] = this.uvFront.get(3).floatValue();
                break;
            }
            case "back": 
            case "south": {
                float[] fArray5 = new float[4];
                fArray5[0] = this.uvBack.get(0).floatValue();
                fArray5[1] = this.uvBack.get(1).floatValue();
                fArray5[2] = this.uvBack.get(2).floatValue();
                fArray = fArray5;
                fArray5[3] = this.uvBack.get(3).floatValue();
                break;
            }
            case "right": 
            case "east": {
                float[] fArray6 = new float[4];
                fArray6[0] = this.uvLeft.get(0).floatValue();
                fArray6[1] = this.uvLeft.get(1).floatValue();
                fArray6[2] = this.uvLeft.get(2).floatValue();
                fArray = fArray6;
                fArray6[3] = this.uvLeft.get(3).floatValue();
                break;
            }
            case "left": 
            case "west": {
                float[] fArray7 = new float[4];
                fArray7[0] = this.uvRight.get(0).floatValue();
                fArray7[1] = this.uvRight.get(1).floatValue();
                fArray7[2] = this.uvRight.get(2).floatValue();
                fArray = fArray7;
                fArray7[3] = this.uvRight.get(3).floatValue();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + direction);
            }
        }
        return fArray;
    }
}

