/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.file;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.LinkedTreeMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.dorianpb.cem.internal.file.JpmFile;
import net.dorianpb.cem.internal.util.CemFairy;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import org.jetbrains.annotations.Nullable;

public final class JemModel {
    private final String baseId;
    private final String model;
    private final String part;
    private final Boolean attach;
    private final Double scale;
    private final LinkedTreeMap<String, String> animations;
    private final JpmFile modelDef;

    JemModel(LinkedTreeMap json, class_2960 path, class_5912 resourceManager) throws IOException {
        JpmFile temp;
        block12: {
            this.baseId = CemFairy.JSONparseString(json.get((Object)"baseId"));
            this.model = CemFairy.JSONparseString(json.get((Object)"model"));
            this.part = CemFairy.JSONparseString(json.get((Object)"part"));
            this.attach = JemModel.JSONparseBool(json.get((Object)"attach"));
            this.scale = CemFairy.JSONparseDouble(json.getOrDefault((Object)"scale", (Object)1.0));
            ArrayList yeah = (ArrayList)json.getOrDefault((Object)"animations", new ArrayList<LinkedTreeMap>(Collections.singletonList(new LinkedTreeMap())));
            this.animations = new LinkedTreeMap();
            yeah.forEach(value -> value.forEach((key, value1) -> this.animations.put(key, (Object)value1.toString())));
            if (this.model != null) {
                class_2960 id = CemFairy.transformPath(this.model, path);
                Optional resourceOptional = resourceManager.method_14486(id);
                if (resourceOptional.isPresent()) {
                    try (InputStream stream = ((class_3298)resourceOptional.get()).method_14482();){
                        LinkedTreeMap file = (LinkedTreeMap)CemFairy.getGson().fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), LinkedTreeMap.class);
                        if (file == null) {
                            throw new IOException("Invalid File");
                        }
                        temp = new JpmFile(file);
                        break block12;
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException exception) {
                        CemFairy.postReadError((Exception)exception, id);
                        throw new IOException("Error loading dependent file: " + id + exception.getMessage());
                    }
                }
                CemFairy.getLogger().warn(" File \"" + id + "\" not found,");
                CemFairy.getLogger().warn(" falling back on reading model definition from " + path.toString() + "!");
                temp = new JpmFile(json);
            } else {
                temp = new JpmFile(json);
            }
        }
        this.modelDef = temp;
        this.validate();
    }

    @Nullable
    private static Boolean JSONparseBool(Object obj) {
        String val = CemFairy.JSONparseString(obj);
        return val == null ? null : Boolean.valueOf(val);
    }

    private void validate() {
        if (this.part == null) {
            throw new InvalidParameterException("Element \"part\" is required");
        }
    }

    public String getPart() {
        return this.part;
    }

    public Double getScale() {
        return this.scale;
    }

    String getModel() {
        return this.model;
    }

    String getId() {
        return this.modelDef.getId();
    }

    public JpmFile getModelDef() {
        return this.modelDef;
    }

    public Map<String, String> getAnimations() {
        return Collections.unmodifiableMap(this.animations);
    }
}

