/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.file;

import com.google.gson.internal.LinkedTreeMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.dorianpb.cem.internal.file.JemModel;
import net.dorianpb.cem.internal.util.CemFairy;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5912;
import org.jetbrains.annotations.Nullable;

public class JemFile {
    private static final Pattern allowTextureChars = Pattern.compile("^[a-z0-9/._\\-]+$");
    @Nullable
    private final class_2960 texture;
    private final List<Double> textureSize;
    private final Float shadowsize;
    private final HashMap<String, JemModel> models;
    private final class_2960 path;

    public JemFile(LinkedTreeMap<String, Object> json, class_2960 path, class_3300 resourceManager) throws IOException {
        class_2960 jankTexture;
        this.textureSize = CemFairy.JSONparseDoubleList(json.get((Object)"textureSize"));
        this.shadowsize = JemFile.JSONparseFloat(json.get((Object)"shadowSize"));
        this.path = path;
        String texturepath = CemFairy.JSONparseString(json.get((Object)"texture"));
        this.texture = texturepath == null || texturepath.isEmpty() ? (resourceManager.method_14486(jankTexture = CemFairy.transformPath(path.method_12832().substring(path.method_12832().lastIndexOf(47) + 1, path.method_12832().lastIndexOf(46)) + ".png", this.path)).isPresent() ? jankTexture : null) : CemFairy.transformPath(texturepath, this.path);
        this.models = new HashMap();
        for (LinkedTreeMap model : (Iterable)json.get((Object)"models")) {
            JemModel newmodel = new JemModel(model, this.path, (class_5912)resourceManager);
            this.models.put(newmodel.getPart(), newmodel);
        }
        this.validate();
    }

    @Nullable
    private static Float JSONparseFloat(Object obj) {
        String val = CemFairy.JSONparseString(obj);
        return val == null ? null : Float.valueOf(val);
    }

    private void validate() {
        if (this.models == null) {
            throw new IllegalStateException("Element \"models\" is required");
        }
        if (this.textureSize == null) {
            throw new IllegalStateException("Element \"textureSize\" is required");
        }
        if (this.texture != null && !allowTextureChars.matcher(this.texture.method_12832()).find()) {
            throw new IllegalStateException("Non [a-z0-9/._-] character in path of location: " + this.texture);
        }
    }

    private JemFile(@Nullable class_2960 texture, List<Double> textureSize, Float shadowsize, HashMap<String, JemModel> models, class_2960 path) {
        this.texture = texture;
        this.textureSize = textureSize;
        this.shadowsize = shadowsize;
        this.models = models;
        this.path = path;
    }

    @Nullable
    public class_2960 getTexture() {
        return this.texture;
    }

    public List<Double> getTextureSize() {
        return Collections.unmodifiableList(this.textureSize);
    }

    public Set<String> getModelList() {
        return Collections.unmodifiableSet(this.models.keySet());
    }

    public JemModel getModel(String key) {
        return this.models.get(key);
    }

    public String getPath() {
        return this.path.method_12832();
    }

    public Float getShadowsize() {
        return this.shadowsize;
    }

    public JemFile getArmorVarient() {
        return new JemFile(this.texture, new ArrayList<Double>(Arrays.asList(64.0, 32.0)), this.shadowsize, this.models, this.path);
    }
}

