/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.methods;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.GenericPeripheral;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.generic.data.FluidData;
import dan200.computercraft.shared.peripheral.generic.methods.ArgumentHelpers;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidMethods
implements GenericPeripheral {
    @Override
    @Nonnull
    public PeripheralType getType() {
        return PeripheralType.ofAdditional("fluid_storage");
    }

    @Override
    @Nonnull
    public ResourceLocation id() {
        return new ResourceLocation("computercraft", "fluid");
    }

    @LuaFunction(mainThread=true)
    public static Map<Integer, Map<String, ?>> tanks(IFluidHandler fluids) {
        HashMap result = new HashMap();
        int size = fluids.getTanks();
        for (int i = 0; i < size; ++i) {
            FluidStack stack = fluids.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            result.put(i + 1, FluidData.fillBasic(new HashMap(4), stack));
        }
        return result;
    }

    @LuaFunction(mainThread=true)
    public static int pushFluid(IFluidHandler from, IComputerAccess computer, String toName, Optional<Integer> limit, Optional<String> fluidName) throws LuaException {
        Fluid fluid = fluidName.isPresent() ? (Fluid)ArgumentHelpers.getRegistryEntry(fluidName.get(), "fluid", ForgeRegistries.FLUIDS) : null;
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IFluidHandler to = FluidMethods.extractHandler(location.getTarget());
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an tank");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        if (actualLimit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        return fluid == null ? FluidMethods.moveFluid(from, actualLimit, to) : FluidMethods.moveFluid(from, new FluidStack(fluid, actualLimit), to);
    }

    @LuaFunction(mainThread=true)
    public static int pullFluid(IFluidHandler to, IComputerAccess computer, String fromName, Optional<Integer> limit, Optional<String> fluidName) throws LuaException {
        Fluid fluid = fluidName.isPresent() ? (Fluid)ArgumentHelpers.getRegistryEntry(fluidName.get(), "fluid", ForgeRegistries.FLUIDS) : null;
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IFluidHandler from = FluidMethods.extractHandler(location.getTarget());
        if (from == null) {
            throw new LuaException("Target '" + fromName + "' is not an tank");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        if (actualLimit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        return fluid == null ? FluidMethods.moveFluid(from, actualLimit, to) : FluidMethods.moveFluid(from, new FluidStack(fluid, actualLimit), to);
    }

    @Nullable
    private static IFluidHandler extractHandler(@Nullable Object object) {
        LazyOptional cap;
        if (object instanceof TileEntity && ((TileEntity)object).func_145837_r()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = ((ICapabilityProvider)object).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)).isPresent()) {
            return (IFluidHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IFluidHandler) {
            return (IFluidHandler)object;
        }
        return null;
    }

    private static int moveFluid(IFluidHandler from, int limit, IFluidHandler to) {
        return FluidMethods.moveFluid(from, from.drain(limit, IFluidHandler.FluidAction.SIMULATE), limit, to);
    }

    private static int moveFluid(IFluidHandler from, FluidStack fluid, IFluidHandler to) {
        return FluidMethods.moveFluid(from, from.drain(fluid, IFluidHandler.FluidAction.SIMULATE), fluid.getAmount(), to);
    }

    private static int moveFluid(IFluidHandler from, FluidStack extracted, int limit, IFluidHandler to) {
        if (extracted == null || extracted.getAmount() <= 0) {
            return 0;
        }
        extracted = extracted.copy();
        extracted.setAmount(Math.min(extracted.getAmount(), limit));
        int inserted = to.fill(extracted.copy(), IFluidHandler.FluidAction.EXECUTE);
        if (inserted <= 0) {
            return 0;
        }
        extracted.setAmount(inserted);
        from.drain(extracted, IFluidHandler.FluidAction.EXECUTE);
        return inserted;
    }
}

