/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.data;

import com.google.gson.JsonParseException;
import dan200.computercraft.shared.peripheral.generic.data.DataHelpers;
import dan200.computercraft.shared.peripheral.generic.data.DetailProviders;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;

public class ItemData {
    @Nonnull
    public static <T extends Map<? super String, Object>> T fillBasicSafe(@Nonnull T data, @Nonnull ItemStack stack) {
        data.put((String)"name", (String)DataHelpers.getId(stack.func_77973_b()));
        data.put((String)"count", stack.func_190916_E());
        return data;
    }

    @Nonnull
    public static <T extends Map<? super String, Object>> T fillBasic(@Nonnull T data, @Nonnull ItemStack stack) {
        ItemData.fillBasicSafe(data, stack);
        String hash = NBTUtil.getNBTHash(stack.func_77978_p());
        if (hash != null) {
            data.put((String)"nbt", (String)hash);
        }
        return data;
    }

    @Nonnull
    public static <T extends Map<? super String, Object>> T fill(@Nonnull T data, @Nonnull ItemStack stack) {
        int hideFlags;
        List<Map<String, Object>> enchants;
        CompoundNBT displayTag;
        if (stack.func_190926_b()) {
            return data;
        }
        ItemData.fillBasic(data, stack);
        data.put((String)"displayName", (String)stack.func_200301_q().getString());
        data.put((String)"maxCount", stack.func_77976_d());
        if (stack.func_77984_f()) {
            data.put((String)"damage", stack.func_77952_i());
            data.put((String)"maxDamage", stack.func_77958_k());
        }
        if (stack.func_77973_b().showDurabilityBar(stack)) {
            data.put((String)"durability", stack.func_77973_b().getDurabilityForDisplay(stack));
        }
        data.put((String)"tags", DataHelpers.getTags(stack.func_77973_b().getTags()));
        data.put((String)"itemGroups", ItemData.getItemGroups(stack));
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("display", 10) && (displayTag = tag.func_74775_l("display")).func_150297_b("Lore", 9)) {
            ListNBT loreTag = displayTag.func_150295_c("Lore", 8);
            data.put((String)"lore", loreTag.stream().map(ItemData::parseTextComponent).filter(Objects::nonNull).map(ITextComponent::getString).collect(Collectors.toList()));
        }
        if (!(enchants = ItemData.getAllEnchants(stack, hideFlags = tag != null ? tag.func_74762_e("HideFlags") : 0)).isEmpty()) {
            data.put((String)"enchantments", enchants);
        }
        if (tag != null && tag.func_74767_n("Unbreakable") && (hideFlags & 4) == 0) {
            data.put((String)"unbreakable", true);
        }
        DetailProviders.fillData(ItemStack.class, data, stack);
        return data;
    }

    @Nullable
    private static ITextComponent parseTextComponent(@Nonnull INBT x) {
        try {
            return ITextComponent.Serializer.func_240643_a_((String)x.func_150285_a_());
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    @Nonnull
    private static List<Map<String, Object>> getItemGroups(@Nonnull ItemStack stack) {
        ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>(1);
        for (ItemGroup group : stack.func_77973_b().getCreativeTabs()) {
            if (group == null) continue;
            HashMap<String, String> groupData = new HashMap<String, String>(2);
            groupData.put("id", group.field_78034_o);
            groupData.put("displayName", group.field_242391_q.getString());
            groups.add(groupData);
        }
        return groups;
    }

    @Nonnull
    private static List<Map<String, Object>> getAllEnchants(@Nonnull ItemStack stack, int hideFlags) {
        ArrayList<Map<String, Object>> enchants = new ArrayList<Map<String, Object>>(0);
        if (stack.func_77973_b() instanceof EnchantedBookItem && (hideFlags & 0x20) == 0) {
            ItemData.addEnchantments(EnchantedBookItem.func_92110_g((ItemStack)stack), enchants);
        }
        if (stack.func_77948_v() && (hideFlags & 1) == 0) {
            ItemData.addEnchantments(stack.func_77986_q(), enchants);
        }
        return enchants;
    }

    private static void addEnchantments(@Nonnull ListNBT rawEnchants, @Nonnull ArrayList<Map<String, Object>> enchants) {
        if (rawEnchants.isEmpty()) {
            return;
        }
        enchants.ensureCapacity(enchants.size() + rawEnchants.size());
        for (Map.Entry entry : EnchantmentHelper.func_226652_a_((ListNBT)rawEnchants).entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer level = (Integer)entry.getValue();
            HashMap<String, Object> enchant = new HashMap<String, Object>(3);
            enchant.put("name", DataHelpers.getId(enchantment));
            enchant.put("level", level);
            enchant.put("displayName", enchantment.func_200305_d(level.intValue()).getString());
            enchants.add(enchant);
        }
    }
}

