/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.container;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public interface ContainerData {
    public void toBytes(PacketBuffer var1);

    default public void open(PlayerEntity player, INamedContainerProvider owner) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)owner, this::toBytes);
    }

    public static <C extends Container, T extends ContainerData> ContainerType<C> toType(Function<PacketBuffer, T> reader, Factory<C, T> factory) {
        return IForgeContainerType.create((id, player, data) -> factory.create(id, player, (ContainerData)reader.apply(data)));
    }

    public static <C extends Container, T extends ContainerData> ContainerType<C> toType(Function<PacketBuffer, T> reader, FixedFactory<C, T> factory) {
        return new FixedPointContainerFactory(reader, factory).type;
    }

    public static class FixedPointContainerFactory<C extends Container, T extends ContainerData>
    implements IContainerFactory<C> {
        private final IContainerFactory<C> impl;
        private final ContainerType<C> type;

        private FixedPointContainerFactory(Function<PacketBuffer, T> reader, FixedFactory<C, T> factory) {
            ContainerType type = this.type = IForgeContainerType.create((IContainerFactory)this);
            this.impl = (id, player, data) -> factory.create(type, id, player, (ContainerData)reader.apply(data));
        }

        public C create(int windowId, PlayerInventory inv, PacketBuffer data) {
            return (C)this.impl.create(windowId, inv, data);
        }
    }

    public static interface FixedFactory<C extends Container, T extends ContainerData> {
        public C create(ContainerType<C> var1, int var2, @Nonnull PlayerInventory var3, T var4);
    }

    public static interface Factory<C extends Container, T extends ContainerData> {
        public C create(int var1, @Nonnull PlayerInventory var2, T var3);
    }
}

