/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.BlockGeneric;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.items.IComputerItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.RegistryObject;

public abstract class BlockComputerBase<T extends TileComputerBase>
extends BlockGeneric
implements IBundledRedstoneBlock {
    private static final ResourceLocation DROP = new ResourceLocation("computercraft", "computer");
    private final ComputerFamily family;

    protected BlockComputerBase(AbstractBlock.Properties settings, ComputerFamily family, RegistryObject<? extends TileEntityType<? extends T>> type) {
        super(settings, type);
        this.family = family;
    }

    @Deprecated
    public void func_220082_b(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, world, pos, oldState, isMoving);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileComputerBase) {
            ((TileComputerBase)tile).updateInputsImmediately();
        }
    }

    @Deprecated
    public boolean func_149744_f(@Nonnull BlockState state) {
        return true;
    }

    @Deprecated
    public int func_176211_b(@Nonnull BlockState state, IBlockReader world, @Nonnull BlockPos pos, @Nonnull Direction incomingSide) {
        TileEntity entity = world.func_175625_s(pos);
        if (!(entity instanceof TileComputerBase)) {
            return 0;
        }
        TileComputerBase computerEntity = (TileComputerBase)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(incomingSide.func_176734_d());
        return computer.getRedstoneOutput(localSide);
    }

    @Nonnull
    protected abstract ItemStack getItem(TileComputerBase var1);

    public ComputerFamily getFamily() {
        return this.family;
    }

    @Deprecated
    public int func_180656_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull Direction incomingSide) {
        return this.func_176211_b(state, world, pos, incomingSide);
    }

    @Override
    public boolean getBundledRedstoneConnectivity(World world, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public int getBundledRedstoneOutput(World world, BlockPos pos, Direction side) {
        TileEntity entity = world.func_175625_s(pos);
        if (!(entity instanceof TileComputerBase)) {
            return 0;
        }
        TileComputerBase computerEntity = (TileComputerBase)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(side);
        return computer.getBundledRedstoneOutput(localSide);
    }

    @Nonnull
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack result;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileComputerBase && !(result = this.getItem((TileComputerBase)tile)).func_190926_b()) {
            return result;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180657_a(@Nonnull World world, PlayerEntity player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable TileEntity tile, @Nonnull ItemStack tool) {
        player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        player.func_71020_j(0.005f);
    }

    public void func_176208_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull PlayerEntity player) {
        if (!(world instanceof ServerWorld)) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)world;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileComputerBase) {
            TileComputerBase computer = (TileComputerBase)tile;
            LootContext.Builder context = new LootContext.Builder(serverWorld).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)player.func_184614_ca()).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216015_a(LootParameters.field_216288_h, (Object)tile).func_216017_a(DROP, (ctx, out) -> out.accept(this.getItem(computer)));
            for (ItemStack item : state.func_215693_a(context)) {
                BlockComputerBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
            }
            state.func_215706_a(serverWorld, pos, player.func_184614_ca());
        }
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile instanceof IComputerTile && stack.func_77973_b() instanceof IComputerItem) {
            String label;
            IComputerTile computer = (IComputerTile)tile;
            IComputerItem item = (IComputerItem)stack.func_77973_b();
            int id = item.getComputerID(stack);
            if (id != -1) {
                computer.setComputerID(id);
            }
            if ((label = item.getLabel(stack)) != null) {
                computer.setLabel(label);
            }
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }
}

