/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import dan200.computercraft.ComputerCraft;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.ResourceLocation;

public abstract class LootTableProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;

    public LootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@Nonnull DirectoryCache cache) {
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        ValidationTracker validation = new ValidationTracker(LootParameterSets.field_216266_g, x -> null, tables::get);
        this.registerLoot((id, table) -> {
            if (tables.containsKey(id)) {
                validation.func_227530_a_("Duplicate loot tables for " + id);
            }
            tables.put((ResourceLocation)id, (LootTable)table);
        });
        tables.forEach((key, value) -> LootTableManager.func_227508_a_((ValidationTracker)validation, (ResourceLocation)key, (LootTable)value));
        Multimap problems = validation.func_227527_a_();
        if (!problems.isEmpty()) {
            problems.forEach((child, problem) -> ComputerCraft.log.warn("Found validation problem in " + child + ": " + problem));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        tables.forEach((key, value) -> {
            Path path = this.getPath((ResourceLocation)key);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)value), (Path)path);
            }
            catch (IOException e) {
                ComputerCraft.log.error("Couldn't save loot table {}", (Object)path, (Object)e);
            }
        });
    }

    protected abstract void registerLoot(BiConsumer<ResourceLocation, LootTable> var1);

    @Nonnull
    public String func_200397_b() {
        return "LootTables";
    }

    private Path getPath(ResourceLocation id) {
        return this.generator.func_200391_b().resolve("data").resolve(id.func_110624_b()).resolve("loot_tables").resolve(id.func_110623_a() + ".json");
    }
}

