/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.render.MonitorTextureBufferShader;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.DirectFixedWidthFontRenderer;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.client.util.DirectBuffers;
import dan200.computercraft.client.util.DirectVertexBuffer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.DirectionUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import org.lwjgl.opengl.GL11;

public class TileEntityMonitorRenderer
extends TileEntityRenderer<TileMonitor> {
    private static final float MARGIN = 0.034375f;
    private static ByteBuffer backingBuffer;

    public TileEntityMonitorRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(@Nonnull TileMonitor monitor, float partialTicks, @Nonnull MatrixStack transform, @Nonnull IRenderTypeBuffer renderer, int lightmapCoord, int overlayLight) {
        ClientMonitor originTerminal = monitor.getClientMonitor();
        if (originTerminal == null) {
            return;
        }
        TileMonitor origin = originTerminal.getOrigin();
        BlockPos monitorPos = monitor.func_174877_v();
        long renderFrame = FrameInfo.getRenderFrame();
        if (originTerminal.lastRenderFrame == renderFrame && !monitorPos.equals((Object)originTerminal.lastRenderPos)) {
            return;
        }
        originTerminal.lastRenderFrame = renderFrame;
        originTerminal.lastRenderPos = monitorPos;
        BlockPos originPos = origin.func_174877_v();
        Direction dir = origin.getDirection();
        Direction front = origin.getFront();
        float yaw = dir.func_185119_l();
        float pitch = DirectionUtil.toPitchAngle(front);
        transform.func_227860_a_();
        transform.func_227861_a_((double)(originPos.func_177958_n() - monitorPos.func_177958_n()) + 0.5, (double)(originPos.func_177956_o() - monitorPos.func_177956_o()) + 0.5, (double)(originPos.func_177952_p() - monitorPos.func_177952_p()) + 0.5);
        transform.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(yaw));
        transform.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
        transform.func_227861_a_(-0.34375, (double)origin.getHeight() - 0.5 - 0.15625 + 0.0, 0.5);
        double xSize = (double)origin.getWidth() - 0.3125;
        double ySize = (double)origin.getHeight() - 0.3125;
        Terminal terminal = originTerminal.getTerminal();
        if (terminal != null) {
            int width = terminal.getWidth();
            int height = terminal.getHeight();
            int pixelWidth = width * 6;
            int pixelHeight = height * 9;
            double xScale = xSize / (double)pixelWidth;
            double yScale = ySize / (double)pixelHeight;
            transform.func_227860_a_();
            transform.func_227862_a_((float)xScale, (float)(-yScale), 1.0f);
            Matrix4f matrix = transform.func_227866_c_().func_227870_a_();
            TileEntityMonitorRenderer.renderTerminal(renderer, matrix, originTerminal, (float)((double)0.034375f / xScale), (float)((double)0.034375f / yScale));
            renderer.getBuffer(RenderType.func_228639_c_());
            transform.func_227865_b_();
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(transform.func_227866_c_().func_227870_a_(), renderer.getBuffer(RenderTypes.TERMINAL_WITH_DEPTH), -0.034375f, 0.034375f, (float)(xSize + (double)0.06875f), (float)(-(ySize + (double)0.06875f)));
        }
        transform.func_227865_b_();
    }

    private static void renderTerminal(IRenderTypeBuffer bufferSource, Matrix4f matrix, ClientMonitor monitor, float xMargin, float yMargin) {
        Terminal terminal = monitor.getTerminal();
        int width = terminal.getWidth();
        int height = terminal.getHeight();
        int pixelWidth = width * 6;
        int pixelHeight = height * 9;
        MonitorRenderer renderType = MonitorRenderer.current();
        boolean redraw = monitor.pollTerminalChanged();
        if (monitor.createBuffer(renderType)) {
            redraw = true;
        }
        switch (renderType) {
            case TBO: {
                if (!MonitorTextureBufferShader.use()) {
                    return;
                }
                if (redraw) {
                    ByteBuffer terminalBuffer = TileEntityMonitorRenderer.getBuffer(width * height * 3);
                    MonitorTextureBufferShader.setTerminalData(terminalBuffer, terminal);
                    DirectBuffers.setBufferData(35882, monitor.tboBuffer, terminalBuffer, 35044);
                    ByteBuffer uniformBuffer = TileEntityMonitorRenderer.getBuffer(276);
                    MonitorTextureBufferShader.setUniformData(uniformBuffer, terminal, !monitor.isColour());
                    DirectBuffers.setBufferData(35345, monitor.tboUniform, uniformBuffer, 35044);
                }
                bufferSource.getBuffer(RenderTypes.TERMINAL_WITH_DEPTH);
                RenderTypes.TERMINAL_WITH_DEPTH.func_228547_a_();
                GlStateManager.func_227756_r_((int)33987);
                GL11.glBindTexture((int)35882, (int)monitor.tboTexture);
                GlStateManager.func_227756_r_((int)33984);
                MonitorTextureBufferShader.setupUniform(matrix, monitor.tboUniform);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(5, DefaultVertexFormats.field_181705_e);
                buffer.func_225582_a_((double)(-xMargin), (double)(-yMargin), 0.0).func_181675_d();
                buffer.func_225582_a_((double)(-xMargin), (double)((float)pixelHeight + yMargin), 0.0).func_181675_d();
                buffer.func_225582_a_((double)((float)pixelWidth + xMargin), (double)(-yMargin), 0.0).func_181675_d();
                buffer.func_225582_a_((double)((float)pixelWidth + xMargin), (double)((float)pixelHeight + yMargin), 0.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_227723_g_((int)0);
                break;
            }
            case VBO: {
                DirectVertexBuffer vbo = monitor.buffer;
                if (redraw) {
                    int vertexSize = RenderTypes.TERMINAL_WITHOUT_DEPTH.func_228663_p_().func_177338_f();
                    ByteBuffer buffer = TileEntityMonitorRenderer.getBuffer(DirectFixedWidthFontRenderer.getVertexCount(terminal) * vertexSize);
                    DirectFixedWidthFontRenderer.drawTerminalWithoutCursor(buffer, 0.0f, 0.0f, terminal, !monitor.isColour(), yMargin, yMargin, xMargin, xMargin);
                    int termIndexes = buffer.position() / vertexSize;
                    DirectFixedWidthFontRenderer.drawCursor(buffer, 0.0f, 0.0f, terminal, !monitor.isColour());
                    buffer.flip();
                    vbo.upload(termIndexes, RenderTypes.TERMINAL_WITHOUT_DEPTH.func_228663_p_(), buffer);
                }
                bufferSource.getBuffer(RenderTypes.TERMINAL_WITHOUT_DEPTH);
                RenderTypes.TERMINAL_WITHOUT_DEPTH.func_228547_a_();
                vbo.draw(matrix, FixedWidthFontRenderer.isCursorVisible(terminal) && FrameInfo.getGlobalCursorBlink() ? vbo.getIndexCount() + 6 : vbo.getIndexCount());
                FixedWidthFontRenderer.drawBlocker(matrix, bufferSource.getBuffer(RenderTypes.TERMINAL_BLOCKER), -xMargin, -yMargin, (float)pixelWidth + xMargin * 2.0f, (float)pixelHeight + yMargin * 2.0f);
                break;
            }
        }
    }

    @Nonnull
    private static ByteBuffer getBuffer(int capacity) {
        ByteBuffer buffer = backingBuffer;
        if (buffer == null || buffer.capacity() < capacity) {
            backingBuffer = buffer == null ? DirectBuffers.createByteBuffer(capacity) : DirectBuffers.resizeByteBuffer(buffer, capacity);
            buffer = backingBuffer;
        }
        buffer.clear();
        return buffer;
    }
}

